/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import wile.anthillinside.ModConfig;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.libmc.Auxiliaries;
import wile.anthillinside.libmc.Networking;
import wile.anthillinside.libmc.Overlay;
import wile.anthillinside.libmc.Registries;

@Mod(value="anthillinside")
public class ModAnthillInside {
    public static final String MODID = "anthillinside";
    public static final String MODNAME = "Anthill Inside";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ModAnthillInside() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        Registries.init(MODID, "ants", reg -> reg.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModContent.init(MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCreativeModeTabContents);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::onBlockBroken);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.TextOverlayGui.on_config(0.75);
        Networking.OverlayTextMessage.setHandler(Overlay.TextOverlayGui::show);
        ModContent.registerMenuGuis();
        ModContent.processContentClientSide();
    }

    private void onCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            Overlay.TextOverlayGui.INSTANCE.onRenderGui(event.getGuiGraphics());
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldOverlay(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                Overlay.TextOverlayGui.INSTANCE.onRenderWorldOverlay(event.getPoseStack(), event.getPartialTick());
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                ModConfig.apply();
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }

        public static void onBlockBroken(BlockEvent.BreakEvent event) {
            if (event.getState() == null || event.getPlayer() == null) {
                return;
            }
            RedAntHive.onGlobalPlayerBlockBrokenEvent(event.getState(), event.getLevel(), event.getPos(), event.getPlayer());
        }
    }
}

