import mods.dropt.Dropt;
// Magicite

Dropt.list("magicite_nonplayer")

  .add(Dropt.rule()
      .matchBlocks(["quark:crystal:*"])
      .matchHarvester(Dropt.harvester()
        .type("NON_PLAYER")
      )
      .addDrop(Dropt.drop()
          .items([<contenttweaker:magicked_stone>])
      )
);
# Nether
Dropt.list("magicite_nether")

  .add(Dropt.rule()
      .matchDimensions([-1])
      .matchBlocks(["quark:crystal:1", "quark:crystal:2", "quark:crystal:3", "quark:crystal:8"])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:death_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:death_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:soul_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:soul_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:disint_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:disint_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:chaos_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:chaos_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:nether_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:nether_quintessence>])
      )
);

Dropt.list("magicite_aether")

  .add(Dropt.rule()
      .matchDimensions([4])
      .matchBlocks(["quark:crystal:0", "quark:crystal:3", "quark:crystal:5", "quark:crystal:7"])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:energy_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:energy_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:life_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:life_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:arcane_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:arcane_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:balance_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:balance_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:aether_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:aether_quintessence>])
      )
);

Dropt.list("magicite_beneath")

  .add(Dropt.rule()
      .matchDimensions([10])
      .matchBlocks(["quark:crystal:2", "quark:crystal:4", "quark:crystal:6", "quark:crystal:7", "quark:crystal:8"])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:poison_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:poison_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:order_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:order_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:mind_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:mind_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:plague_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:plague_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:holding_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:holding_quintessence>])
      )
);

Dropt.list("magicite_end")

  .add(Dropt.rule()
      .matchDimensions([1])
      .matchBlocks(["quark:crystal:3", "quark:crystal:4", "quark:crystal:6", "quark:crystal:7", "quark:crystal:8"])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:illusion_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:illusion_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:creation_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:creation_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:knowledge_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:knowledge_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:end_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:end_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:holding_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:holding_quintessence>])
      )
);

Dropt.list("magicite_tf")

  .add(Dropt.rule()
      .matchDimensions([7])
      .matchBlocks(["quark:crystal:3", "quark:crystal:4", "quark:crystal:6", "quark:crystal:7", "quark:crystal:8"])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:trans_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:trans_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:strength_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:strength_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(15)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:nature_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:nature_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:draconic_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:draconic_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fae_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fae_quintessence>])
      )
);

# Overworld
Dropt.list("magicite_white")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:sol_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for gorgon stage matched, transformation
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedGorgon"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:trans_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sea serpent stage matched, balance
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSeaSerpent"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:balance_quintessence>])
      )
)
  .add(Dropt.rule() // rule for quazar stage matched, arcane
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedQuazar"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:arcane_quintessence>])
      )
)
  .add(Dropt.rule() // rule for undertaker stage matched, soul
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedUndertaker"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:soul_quintessence>])
      )
)
  .add(Dropt.rule() // rule for harvester stage matched, life
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedHarvester"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:life_quintessence>])
      )
)
  .add(Dropt.rule() // rule for siren stage matched, illusion
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSiren"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:illusion_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf, fae
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:fae_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf & killed end dragon, draconic
      .fallthrough()
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:draconic_quintessence>])
      )
)
  .add(Dropt.rule() // entered aether, aether
      .matchBlocks(["quark:crystal:0"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredAether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:aether_quintessence>])
      )
);

Dropt.list("magicite_red")

  .add(Dropt.rule() // rule for no stages matched
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for lord bastion stage matched, death
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedLordBastion"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:death_quintessence>])
      )
)
  .add(Dropt.rule() // rule for pied piper stage matched, knowledge
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedPiedPiper"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:knowledge_quintessence>])
      )
)
  .add(Dropt.rule() // rule for gorgon stage matched, transformation
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedGorgon"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:trans_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sludgeling stage matched, creation
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSludgeLord"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:creation_quintessence>])
      )
)
  .add(Dropt.rule() // rule for harvester stage matched, life
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedHarvester"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:life_quintessence>])
      )
)
  .add(Dropt.rule() // rule for frostmaw stage matched, energy
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedFrostmaw"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:energy_quintessence>])
      )
)
  .add(Dropt.rule() // rule for destroyer stage matched, chaos
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedDestroyer"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:chaos_quintessence>])
      )
)
  .add(Dropt.rule() // rule for myrmex queen stage matched, order
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedMyrmexQueen"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:order_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf & killed end dragon, draconic
      .fallthrough()
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:draconic_quintessence>])
      )
)
  .add(Dropt.rule() // entered nether, nether
      .matchBlocks(["quark:crystal:1"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredNether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:nether_quintessence>])
      )
);


Dropt.list("magicite_orange")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:earth_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for lord bastion stage matched, death
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedLordBastion"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:death_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sludgeling stage matched, creation
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSludgeLord"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:creation_quintessence>])
      )
)
  .add(Dropt.rule() // rule for wroughtnaut stage matched, mind
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedWroughtnaut"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:mind_quintessence>])
      )
)
  .add(Dropt.rule() // rule for skydrake stage matched, poison
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSkydrake"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:poison_quintessence>])
      )
)
  .add(Dropt.rule() // rule for undertaker stage matched, soul
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedUndertaker"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:soul_quintessence>])
      )
)
  .add(Dropt.rule() // rule for harvester stage matched, life
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedHarvester"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:life_quintessence>])
      )
)
  .add(Dropt.rule() // rule for destroyer stage matched, chaos
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedDestroyer"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:chaos_quintessence>])
      )
)
  .add(Dropt.rule() // rule for myrmex queen stage matched, order
      .fallthrough()
      .matchBlocks(["quark:crystal:2"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedMyrmexQueen"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:order_quintessence>])
      )
)
  .add(Dropt.rule() // entered nether, nether
      .fallthrough()
      .matchBlocks(["quark:crystal:"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredNether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:nether_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath, plague
      .matchBlocks(["quark:crystal:"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredBeneath"])
        .gameStages("WHITELIST", "ALL", ["minedMythril"])
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:plague_quintessence>])
      )
); 

Dropt.list("magicite_yellow")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:sol_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:fire_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:earth_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for sludgeling stage matched, creation
      .fallthrough()
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSludgeLord"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:creation_quintessence>])
      )
)
  .add(Dropt.rule() // rule for skydrake stage matched, poison
      .fallthrough()
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSkydrake"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:poison_quintessence>])
      )
)
  .add(Dropt.rule() // rule for ithaqua stage matched, nature
      .fallthrough()
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedIthaqua"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:nature_quintessence>])
      )
)
  .add(Dropt.rule() // entered end, end
      .fallthrough()
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:end_quintessence>])
      )
)
  .add(Dropt.rule() // entered aether, aether
      .matchBlocks(["quark:crystal:3"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredAether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:aether_quintessence>])
      )
);

Dropt.list("magicite_green")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:earth_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:earth_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for pied piper stage matched, knowledge
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedPiedPiper"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:knowledge_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sea serpent stage matched, balance
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSeaSerpent"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:balance_quintessence>])
      )
)
  .add(Dropt.rule() // rule for wroughtnaut stage matched, mind
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedWroughtnaut"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:mind_quintessence>])
      )
)
  .add(Dropt.rule() // rule for skydrake stage matched, poison
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSkydrake"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:poison_quintessence>])
      )
)
  .add(Dropt.rule() // rule for ithaqua stage matched, nature
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedIthaqua"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:nature_quintessence>])
      )
)
  .add(Dropt.rule() // entered end, end
      .fallthrough()
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:end_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath, plague
      .matchBlocks(["quark:crystal:4"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredBeneath"])
        .gameStages("WHITELIST", "ALL", ["minedMythril"])
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:plague_quintessence>])
      )
);

Dropt.list("magicite_blue")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:air_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:air_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for pied piper stage matched, knowledge
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedPiedPiper"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:knowledge_quintessence>])
      )
)
  .add(Dropt.rule() // rule for gorgon stage matched, transformation
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedGorgon"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:trans_quintessence>])
      )
)
  .add(Dropt.rule() // rule for quazar stage matched, arcane
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedQuazar"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:arcane_quintessence>])
      )
)
  .add(Dropt.rule() // rule for ithaqua stage matched, nature
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedIthaqua"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:nature_quintessence>])
      )
)
  .add(Dropt.rule() // rule for frostmaw stage matched, energy
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedFrostmaw"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:energy_quintessence>])
      )
)
  .add(Dropt.rule() // rule for cyclops stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedCyclops"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:strength_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf, fae
      .matchBlocks(["quark:crystal:5"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:fae_quintessence>])
      )
);

Dropt.list("magicite_indigo")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:water_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for quazar stage matched, arcane
      .fallthrough()
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedQuazar"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:arcane_quintessence>])
      )
)
  .add(Dropt.rule() // rule for frostmaw stage matched, energy
      .fallthrough()
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedFrostmaw"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:energy_quintessence>])
      )
)
  .add(Dropt.rule() // rule for cyclops stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedCyclops"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:strength_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sun chief stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSunChief"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:disint_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath & end, void
      .matchBlocks(["quark:crystal:6"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:holding_quintessence>])
      )
);

Dropt.list("magicite_violet")

  .add(Dropt.rule()
      .fallthrough()  
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for wroughtnaut stage matched, mind
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedWroughtnaut"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:mind_quintessence>])
      )
)
  .add(Dropt.rule() // rule for siren stage matched, illusion
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSiren"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:illusion_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sun chief stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSunChief"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:disint_quintessence>])
      )
)
  .add(Dropt.rule() // rule for destroyer stage matched, chaos
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedDestroyer"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:chaos_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath & end, void
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:holding_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf, fae
      .fallthrough()
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:fae_quintessence>])
      )
)
  .add(Dropt.rule() // entered aether, aether
      .matchBlocks(["quark:crystal:7"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredAether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:aether_quintessence>])
      )
);


Dropt.list("magicite_black")

  .add(Dropt.rule()
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .matchHarvester(Dropt.harvester()
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
          .items([<contenttweaker:magicked_stone>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(33)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:luna_quintessence>])
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(10)) 
          .items("ALL", [<contenttweaker:magicked_stone>, <contenttweaker:vis_speck>, <contenttweaker:luna_quintessence>])
      )
  )
  .add(Dropt.rule() // rule for lord bastion stage matched, death
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedLordBastion"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:death_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sea serpent stage matched, balance
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSeaSerpent"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:balance_quintessence>])
      )
)
  .add(Dropt.rule() // rule for undertaker stage matched, soul
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedUndertaker"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:soul_quintessence>])
      )
)
  .add(Dropt.rule() // rule for siren stage matched, illusion
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSiren"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:illusion_quintessence>])
      )
)
  .add(Dropt.rule() // rule for cyclops stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedCyclops"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:strength_quintessence>])
      )
)
  .add(Dropt.rule() // rule for sun chief stage matched, disint
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])      
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedSunChief"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:disint_quintessence>])
      )
)
  .add(Dropt.rule() // rule for myrmex queen stage matched, order
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["killedMyrmexQueen"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(66))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(33)) 
          .items([<contenttweaker:order_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath & end, void
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:holding_quintessence>])
      )
)
  .add(Dropt.rule() // entered end, end
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:end_quintessence>])
      )
)
  .add(Dropt.rule() // entered tf & killed end dragon, draconic
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:draconic_quintessence>])
      )
)
  .add(Dropt.rule() // entered nether, nether
      .fallthrough()
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredNether"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:nether_quintessence>])
      )
)
  .add(Dropt.rule() // entered beneath, plague
      .matchBlocks(["quark:crystal:8"])
      .matchDimensions([0])
      .replaceStrategy("ADD")
      .matchHarvester(Dropt.harvester()
        .gameStages("WHITELIST", "ALL", ["enteredBeneath"])
        .gameStages("WHITELIST", "ALL", ["minedMythril"])
        .gameStages("WHITELIST", "ALL", ["enteredEnd"])
        .gameStages("WHITELIST", "ALL", ["killedEnderDragon"])
        .gameStages("WHITELIST", "ALL", ["enteredTwilightForest"])
        .type("PLAYER")
      )
      .addDrop(Dropt.drop()
          .selector(Dropt.weight(90))
      ) 
      .addDrop(Dropt.drop() // staged drops
          .selector(Dropt.weight(10)) 
          .items([<contenttweaker:plague_quintessence>])
      )
);