/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.arl.block.tile.TileMod;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.world.feature.MonsterBoxes;

public class TileMonsterBox
extends TileMod
implements ITickable {
    private int breakProgress;

    public void func_73660_a() {
        boolean doBreak;
        if (this.field_145850_b.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            this.field_145850_b.func_175688_a(this.breakProgress == 0 ? EnumParticleTypes.FLAME : EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
        boolean bl = doBreak = this.breakProgress > 0;
        if (!doBreak) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_186662_g(MonsterBoxes.activationRadius));
            boolean bl2 = doBreak = players.size() > 0;
        }
        if (doBreak) {
            if (this.breakProgress == 0) {
                this.field_145850_b.func_184133_a(null, pos, QuarkSounds.BLOCK_MONSTER_BOX_GROWL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            ++this.breakProgress;
            if (this.breakProgress > MonsterBoxes.activationTime) {
                this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(pos)));
                this.field_145850_b.func_175698_g(pos);
                this.spawnMobs();
            }
        }
    }

    private void spawnMobs() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        float r = this.field_145850_b.field_73012_v.nextFloat();
        double min = 0.0;
        Pool pool = null;
        for (int i = 0; i < MonsterBoxes.pools.length; ++i) {
            Pool currentPool = new Pool(MonsterBoxes.pools[i]);
            double max = min + currentPool.chance;
            if ((double)r < max) {
                pool = currentPool;
                break;
            }
            min = max;
        }
        assert (pool != null);
        int mobCount = pool.minCount + this.field_145850_b.field_73012_v.nextInt(Math.max(pool.maxCount - pool.minCount + 1, 1));
        for (int i = 0; i < mobCount; ++i) {
            Entity e = null;
            float r_ = this.field_145850_b.field_73012_v.nextFloat();
            double min_ = 0.0;
            for (Map.Entry<EntityEntry, Double> entry : pool.entities.entrySet()) {
                EntityEntry entity = entry.getKey();
                Double chance = entry.getValue();
                double max = min_ + chance;
                if ((double)r_ < max) {
                    e = entity.newInstance(this.field_145850_b);
                    break;
                }
                min_ = max;
            }
            double motionMultiplier = 0.4;
            assert (e != null);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            e.field_70159_w = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * motionMultiplier;
            e.field_70181_x = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * motionMultiplier;
            e.field_70179_y = ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * motionMultiplier;
            this.field_145850_b.func_72838_d(e);
        }
    }

    private static class Pool {
        public double chance;
        public int minCount;
        public int maxCount;
        public Map<EntityEntry, Double> entities = new HashMap<EntityEntry, Double>();

        public Pool(String source) {
            int start;
            int i;
            for (i = start = 0; i < source.length(); ++i) {
                if (source.charAt(i) != ' ') continue;
                this.chance = Double.parseDouble(source.substring(start, i));
                start = i + 1;
                break;
            }
            for (i = start; i < source.length(); ++i) {
                if (source.charAt(i) != '-') continue;
                this.minCount = Integer.parseInt(source.substring(start, i));
                start = i + 1;
                break;
            }
            for (i = start; i < source.length(); ++i) {
                if (source.charAt(i) != ':') continue;
                this.maxCount = Integer.parseInt(source.substring(start, i));
                start = i + 2;
                break;
            }
            while (start < source.length()) {
                int i2;
                double mobChance = 0.0;
                String mobId = null;
                for (i2 = start; i2 < source.length(); ++i2) {
                    if (source.charAt(i2) != ' ') continue;
                    mobChance = Double.parseDouble(source.substring(start, i2));
                    start = i2 + 1;
                    break;
                }
                for (i2 = start; i2 < source.length(); ++i2) {
                    if (source.charAt(i2) != ';') continue;
                    mobId = source.substring(start, i2);
                    start = i2 + 2;
                    break;
                }
                assert (mobId != null);
                this.entities.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId)), mobChance);
            }
        }
    }
}

