/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.gui.GuiArchaeologist;
import vazkii.quark.world.client.render.RenderArchaeologist;
import vazkii.quark.world.entity.EntityArchaeologist;
import vazkii.quark.world.item.ItemArchaeologistHat;
import vazkii.quark.world.world.ArchaeologistHouseGenerator;

public class Archaeologist
extends Feature {
    public static final ResourceLocation HOUSE_STRUCTURE = new ResourceLocation("quark", "archaeologist_house");
    public static final ResourceLocation ARCHAEOLOGIST_LOOT_TABLE = new ResourceLocation("quark", "chests/archaeologist");
    public static double chance;
    public static int maxY;
    public static int minY;
    public static DimensionConfig dims;
    public static Item archaeologist_hat;
    public static boolean enableHat;
    public static boolean sellHat;
    public static boolean dropHat;
    public static boolean hatIncreasesOreYield;
    public static float increaseChance;

    @Override
    public void setupConfig() {
        chance = this.loadLegacyPropChance("Percentage Chance Per Chunk", "Chance Per Chunk", "The chance that the generator will attempt to place an Archaeologist in a chunk", 0.1);
        maxY = this.loadPropInt("Max Y", "", 50);
        minY = this.loadPropInt("Min Y", "", 20);
        dims = new DimensionConfig(this.configCategory);
        enableHat = this.loadPropBool("Enable Hat", "", true);
        sellHat = this.loadPropBool("Sell Hat", "Set to false to make the archaeologist not sell the hat", true);
        dropHat = this.loadPropBool("Drop Hat", "Set to false to make the archaeologist not drop the hat", true);
        hatIncreasesOreYield = this.loadPropBool("Hat Increases Ore Yield", "Set to false to make the hat not increase ore yield", true);
        increaseChance = (float)this.loadPropDouble("Yield Increase Chance", "The chance for the hat to increase ore yield, 0 is 0%, 1 is 100%", 0.25);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableHat) {
            archaeologist_hat = new ItemArchaeologistHat();
        }
        String archaeologistName = "quark:archaeologist";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(archaeologistName), EntityArchaeologist.class, (String)archaeologistName, (int)16, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)11900526, (int)11762530);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ArchaeologistHouseGenerator(), (int)3000);
        LootTableList.func_186375_a((ResourceLocation)ARCHAEOLOGIST_LOOT_TABLE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityArchaeologist.class, RenderArchaeologist.FACTORY);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiOpen(GuiOpenEvent event) {
        GuiMerchant guiMerchant;
        IMerchant merchant;
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiMerchant && (merchant = (guiMerchant = (GuiMerchant)gui).func_147035_g()) instanceof EntityArchaeologist) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            event.setGui((GuiScreen)new GuiArchaeologist(player.field_71071_by, merchant, player.field_70170_p));
        }
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (enableHat && hatIncreasesOreYield) {
            IBlockState state;
            Block block;
            ItemStack stack;
            ItemStack drop;
            List drops;
            EntityPlayer player = event.getHarvester();
            if (player == null) {
                return;
            }
            ItemStack hat = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!(hat.func_77973_b() != archaeologist_hat || (drops = event.getDrops()).size() != 1 || (drop = (ItemStack)drops.get(0)).func_190926_b() || drop.func_77973_b() instanceof ItemBlock || drop.func_190916_E() >= drop.func_77976_d() || (stack = new ItemStack(block = (state = event.getState()).func_177230_c())).func_190926_b())) {
                int[] ids;
                for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)i);
                    if (!name.matches("^ore[A-Z][a-zA-Z]+$")) continue;
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < increaseChance)) break;
                    drop.func_190917_f(1);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("archeologist_hat")) continue;
            mapping.remap((IForgeRegistryEntry)archaeologist_hat);
        }
    }

    @SubscribeEvent
    public void missingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            EntityEntry entry;
            if (!mapping.key.func_110623_a().equals("archeologist") || (entry = EntityRegistry.getEntry(EntityArchaeologist.class)) == null) continue;
            mapping.remap((IForgeRegistryEntry)entry);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

