/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.misc.feature.Pickarang;

public class EntityPickarang
extends EntityThrowable {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityPickarang.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(EntityPickarang.class, (DataSerializer)DataSerializers.field_187198_h);
    private int liveTime;
    private int slot;
    private static final ThreadLocal<Boolean> IS_PICKARANG_UPDATING = ThreadLocal.withInitial(() -> false);
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";

    public EntityPickarang(World worldIn) {
        super(worldIn);
    }

    public EntityPickarang(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_70107_b(this.field_70165_t, throwerIn.field_70163_u + (double)throwerIn.func_70047_e(), this.field_70161_v);
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.func_77946_l());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)new ItemStack(Pickarang.pickarang));
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        Entity hit;
        if (((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue() || this.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase owner = this.func_85052_h();
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.field_70180_af.func_187227_b(RETURNING, (Object)true);
            if (!(owner instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)owner;
            BlockPos hit2 = result.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(hit2);
            float hardness = state.func_185887_b(this.field_70170_p, hit2);
            if ((double)hardness <= Pickarang.maxHardness && hardness >= 0.0f) {
                ItemStack prev = player.func_184614_ca();
                player.func_184611_a(EnumHand.MAIN_HAND, this.getStack());
                if (player.field_71134_c.func_180237_b(hit2)) {
                    this.field_70170_p.func_180498_a(null, 2001, hit2, Block.func_176210_f((IBlockState)state));
                } else {
                    this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
                }
                this.setStack(player.func_184614_ca());
                player.func_184611_a(EnumHand.MAIN_HAND, prev);
            } else {
                this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
            }
        } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && (hit = result.field_72308_g) != owner) {
            this.setReturning();
            if (hit instanceof EntityPickarang) {
                ((EntityPickarang)hit).setReturning();
                this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
            } else {
                ItemStack pickarang = this.getStack();
                Multimap modifiers = pickarang.func_111283_C(EntityEquipmentSlot.MAINHAND);
                if (owner != null) {
                    int cooldownPeriod;
                    ItemStack prev = owner.func_184614_ca();
                    owner.func_184611_a(EnumHand.MAIN_HAND, pickarang);
                    owner.func_110140_aT().func_111147_b(modifiers);
                    int oldLastSwing = owner.field_184617_aD;
                    owner.field_184617_aD = cooldownPeriod = (int)(1.0 / owner.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0);
                    Pickarang.setActivePickarang(this);
                    if (owner instanceof EntityPlayer) {
                        ((EntityPlayer)owner).func_71059_n(hit);
                    } else {
                        owner.func_70652_k(hit);
                    }
                    Pickarang.setActivePickarang(null);
                    owner.field_184617_aD = oldLastSwing;
                    this.setStack(owner.func_184614_ca());
                    owner.func_184611_a(EnumHand.MAIN_HAND, prev);
                    owner.func_110140_aT().func_111148_a(modifiers);
                } else {
                    AttributeMap map = new AttributeMap();
                    map.func_111151_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
                    map.func_111147_b(modifiers);
                    ItemStack stack = this.getStack();
                    stack.func_96631_a(1, this.field_70170_p.field_73012_v, null);
                    this.setStack(stack);
                    hit.func_70097_a(new EntityDamageSourceIndirect("player", (Entity)this, (Entity)this).func_76349_b(), (float)map.func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
            }
        }
    }

    protected void setReturning() {
        this.field_70180_af.func_187227_b(RETURNING, (Object)true);
    }

    public boolean func_70067_L() {
        return IS_PICKARANG_UPDATING.get();
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70071_h_() {
        IS_PICKARANG_UPDATING.set(true);
        super.func_70071_h_();
        IS_PICKARANG_UPDATING.set(false);
        if (this.field_70128_L) {
            return;
        }
        boolean returning = (Boolean)this.field_70180_af.func_187225_a(RETURNING);
        ++this.liveTime;
        if (!returning) {
            if (this.liveTime > Pickarang.timeout) {
                this.setReturning();
            }
        } else {
            this.field_70145_X = true;
            ItemStack stack = this.getStack();
            int eff = this.getEfficiencyModifier();
            List items = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(2.0));
            List xp = this.field_70170_p.func_72872_a(EntityXPOrb.class, this.func_174813_aQ().func_186662_g(2.0));
            Vec3d ourPos = this.func_174791_d();
            for (EntityItem item : items) {
                if (item.func_184218_aH()) continue;
                item.func_184220_m((Entity)this);
                item.func_174867_a(2);
            }
            for (EntityXPOrb xpOrb : xp) {
                if (xpOrb.func_184218_aH()) continue;
                xpOrb.func_184220_m((Entity)this);
                xpOrb.field_70532_c = 2;
            }
            EntityLivingBase owner = this.func_85052_h();
            if (owner == null || owner.field_70128_L || !(owner instanceof EntityPlayer)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(stack, 0.0f);
                    this.func_70106_y();
                }
                return;
            }
            Vec3d ownerPos = owner.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
            Vec3d motion = ownerPos.func_178788_d(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.func_189985_c() < motionMag) {
                EntityPlayer player = (EntityPlayer)owner;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(this.slot);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (!stack.func_190926_b()) {
                        if (!player.field_70128_L && stackInSlot.func_190926_b()) {
                            player.field_71071_by.func_70299_a(this.slot, stack);
                        } else if (player.field_70128_L || !player.field_71071_by.func_70441_a(stack)) {
                            player.func_71019_a(stack, false);
                        }
                    }
                    if (!player.field_70128_L) {
                        ItemStack drop;
                        for (EntityItem item : items) {
                            drop = item.func_92059_d();
                            if (!player.func_191521_c(drop)) {
                                player.func_71019_a(drop, false);
                            }
                            item.func_70106_y();
                        }
                        for (EntityXPOrb xpOrb : xp) {
                            xpOrb.func_70100_b_(player);
                        }
                        for (Entity riding : this.func_184188_bt()) {
                            if (riding.field_70128_L) continue;
                            if (riding instanceof EntityItem) {
                                drop = ((EntityItem)riding).func_92059_d();
                                if (!player.func_191521_c(drop)) {
                                    player.func_71019_a(drop, false);
                                }
                                riding.func_70106_y();
                                continue;
                            }
                            if (!(riding instanceof EntityXPOrb)) continue;
                            riding.func_70100_b_(player);
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                motion = motion.func_72432_b().func_186678_a(0.7 + (double)((float)eff * 0.325f));
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return super.func_184219_q(passenger) || passenger instanceof EntityItem || passenger instanceof EntityXPOrb;
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.PLAYERS;
    }

    public int getEfficiencyModifier() {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)this.getStack());
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    public void setStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(RETURNING, (Object)compound.func_74767_n(TAG_RETURNING));
        this.liveTime = compound.func_74762_e(TAG_LIVE_TIME);
        this.slot = compound.func_74762_e(TAG_RETURN_SLOT);
        if (compound.func_74764_b(TAG_ITEM_STACK)) {
            this.setStack(new ItemStack(compound.func_74775_l(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack(Pickarang.pickarang));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(TAG_RETURNING, ((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue());
        compound.func_74768_a(TAG_LIVE_TIME, this.liveTime);
        compound.func_74768_a(TAG_RETURN_SLOT, this.slot);
        compound.func_74782_a(TAG_ITEM_STACK, (NBTBase)this.getStack().serializeNBT());
    }

    protected float func_70185_h() {
        return 0.0f;
    }
}

