/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.quark.base.module.Feature;

public class StackableItems
extends Feature {
    public static String[] items;

    @Override
    public void setupConfig() {
        int minecarts = 16;
        int soups = 64;
        int saddle = 8;
        if (this.hasConfigKey("Minecarts")) {
            minecarts = Math.min(64, this.loadPropInt("Minecarts", "", 16));
            this.removeLegacyKey("Minecarts");
        }
        if (this.hasConfigKey("Soups")) {
            soups = Math.min(64, this.loadPropInt("Soups", "", 64));
            this.removeLegacyKey("Soups");
        }
        if (this.hasConfigKey("Saddle")) {
            saddle = Math.min(64, this.loadPropInt("Saddle", "", 8));
            this.removeLegacyKey("Saddle");
        }
        items = this.loadPropStringList("Stackable Items", "The format for setting an item's max size is item name|stacksize. i.e. `minecraft:saddle|8`", new String[]{Items.field_151143_au.getRegistryName() + "|" + minecarts, Items.field_151108_aI.getRegistryName() + "|" + minecarts, Items.field_151095_cc.getRegistryName() + "|" + minecarts, Items.field_151109_aJ.getRegistryName() + "|" + minecarts, Items.field_151140_bW.getRegistryName() + "|" + minecarts, Items.field_151142_bV.getRegistryName() + "|" + minecarts, Items.field_151009_A.getRegistryName() + "|" + soups, Items.field_179560_bq.getRegistryName() + "|" + soups, Items.field_185165_cW.getRegistryName() + "|" + soups, Items.field_151141_av.getRegistryName() + "|" + saddle});
    }

    @Override
    public void init() {
        for (String key : items) {
            String[] split = key.split("\\|");
            if (split.length != 2 || !Pattern.matches("\\d+", split[1])) continue;
            ResourceLocation loc = new ResourceLocation(split[0]);
            int size = Math.min(64, Math.max(0, Integer.parseInt(split[1])));
            for (Item item : ForgeRegistries.ITEMS) {
                if (!loc.equals((Object)item.getRegistryName())) continue;
                item.func_77625_d(size);
            }
        }
    }

    @SubscribeEvent
    public void finishEvent(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack original = event.getItem();
            ItemStack result = event.getResultStack();
            if (original.func_190916_E() > 1 && (result.func_77973_b() == Items.field_151054_z || result.func_77973_b() == Items.field_151133_ar)) {
                ItemStack newResult = original.func_77946_l();
                newResult.func_190920_e(original.func_190916_E() - 1);
                event.setResultStack(newResult);
                player.func_191521_c(result);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

