/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.util.ItemMetaHelper;

public class QuickArmorSwapping
extends Feature {
    public static boolean offhandSwapping;
    private static String[] tempBlacklist;
    public static Set<Pair<Item, Integer>> armorBlacklist;

    @Override
    public void setupConfig() {
        offhandSwapping = this.loadPropBool("Swap off-hand with armor", "", true);
        tempBlacklist = this.loadPropStringList("Armor Blacklist", "Armor that should be prevented from being quick-swapped\nFormat is modid:item[:meta]", new String[0]);
    }

    @Override
    public void postPreInit() {
        armorBlacklist = ItemMetaHelper.getFromStringArray("armor swapping blacklist item", tempBlacklist).stream().filter(i -> !i.func_190926_b()).map(s -> Pair.of((Object)s.func_77973_b(), (Object)s.func_77960_j())).collect(Collectors.toSet());
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (target == null || player == null) {
            return;
        }
        if (target.field_70170_p.field_72995_K || player.func_175149_v() || player.func_184812_l_() || !(target instanceof EntityArmorStand)) {
            return;
        }
        if (player.func_70093_af()) {
            event.setCanceled(true);
            EntityArmorStand armorStand = (EntityArmorStand)event.getTarget();
            this.swapSlot(player, armorStand, EntityEquipmentSlot.HEAD);
            this.swapSlot(player, armorStand, EntityEquipmentSlot.CHEST);
            this.swapSlot(player, armorStand, EntityEquipmentSlot.LEGS);
            this.swapSlot(player, armorStand, EntityEquipmentSlot.FEET);
            if (offhandSwapping) {
                this.swapSlot(player, armorStand, EntityEquipmentSlot.OFFHAND);
            }
        }
    }

    private void swapSlot(EntityPlayer player, EntityArmorStand armorStand, EntityEquipmentSlot slot) {
        ItemStack playerItem = player.func_184582_a(slot);
        if (armorBlacklist.contains(Pair.of((Object)playerItem.func_77973_b(), (Object)playerItem.func_77960_j()))) {
            return;
        }
        ItemStack armorStandItem = armorStand.func_184582_a(slot);
        if (armorBlacklist.contains(Pair.of((Object)armorStandItem.func_77973_b(), (Object)armorStandItem.func_77960_j()))) {
            return;
        }
        player.func_184201_a(slot, armorStandItem);
        armorStand.func_184201_a(slot, playerItem);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"iberia"};
    }
}

