/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class HoeSickle
extends Feature {
    public static boolean hoesCanHaveFortune;
    public static String[] hoeRanges;

    @Override
    public void setupConfig() {
        hoesCanHaveFortune = this.loadPropBool("Hoes Can Have Fortune", "Can hoes have Fortune anviled on?", true);
        hoeRanges = this.loadPropStringList("Hoe ranges", "in all four directions: 1 is 1x1, 2 is 3x3, 3 is 5x5 and so on", new String[]{"minecraft:diamond_hoe 3", "minecraft:iron_hoe 2", "minecraft:golden_hoe 2", "minecraft:stone_hoe 2", "minecraft:wooden_hoe 1"});
    }

    public static int getRange(Item item) {
        if (!ModuleLoader.isFeatureEnabled(HoeSickle.class)) {
            return 1;
        }
        for (String hoeType : hoeRanges) {
            String[] parts = hoeType.split(" ");
            if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(parts[0])) || ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0])) != item) continue;
            return Integer.parseInt(parts[1]);
        }
        return 1;
    }

    public static boolean canFortuneApply(Enchantment enchantment, ItemStack stack) {
        return enchantment == Enchantments.field_185308_t && hoesCanHaveFortune && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemHoe;
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        BlockPos basePos = event.getPos();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && this.canHarvest(world, basePos, event.getState())) {
            int range = HoeSickle.getRange(stack.func_77973_b());
            for (int i = 1 - range; i < range; ++i) {
                for (int k = 1 - range; k < range; ++k) {
                    IBlockState state;
                    BlockPos pos;
                    if (i == 0 && k == 0 || !this.canHarvest(world, pos = basePos.func_177982_a(i, 0, k), state = world.func_180495_p(pos))) continue;
                    Block block = state.func_177230_c();
                    if (block.canHarvestBlock((IBlockAccess)world, pos, player)) {
                        block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), stack);
                    }
                    world.func_175698_g(pos);
                    world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                }
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private boolean canHarvest(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            EnumPlantType type = plant.getPlantType((IBlockAccess)world, pos);
            return type != EnumPlantType.Water && type != EnumPlantType.Desert;
        }
        return state.func_185904_a() == Material.field_151585_k && block.func_176200_f((IBlockAccess)world, pos);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

