/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.util.ItemMetaHelper;
import vazkii.quark.tweaks.ai.EntityAITemptFixed;

public class AddTemptItems
extends Feature {
    private static String[] temptStrings;
    public static Map<ResourceLocation, Set<ItemStack>> tempts;

    @Override
    public void setupConfig() {
        temptStrings = this.loadPropStringList("Tempt Items", "Items that a listed entity should follow. The entity must extend EntityLiving.\nFormat is 'modid:entityid;modid:itemid[:meta][,modid:itemid[:meta]]...'. Unset meta will default wildcard.", new String[]{"minecraft:villager;minecraft:emerald_block", "quark:archaeologist;minecraft:emerald_block,minecraft:bone_block"});
        EntityAITemptFixed.tickDelay = this.loadPropInt("Tempt Reset Delay", "Delay in ticks before resetting the task after getting interrupted", 100);
    }

    @Override
    public void init() {
        AddTemptItems.loadFromConfig();
    }

    private static void loadFromConfig() {
        tempts = Arrays.stream(temptStrings).map(s -> s.split(";")).filter(s -> ((String[])s).length > 1).map(s -> new AbstractMap.SimpleEntry(new ResourceLocation(s[0]), Arrays.stream(s[1].split(",")).map(i -> ItemMetaHelper.getFromString("tempt item", i)).flatMap(Collection::stream).filter(i -> i != null && !i.func_190926_b()).collect(Collectors.toSet()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        ResourceLocation r = EntityList.func_191301_a((Entity)event.getEntity());
        if (event.getEntity() instanceof EntityLiving && tempts.containsKey(r)) {
            EntityLiving e = (EntityLiving)event.getEntity();
            for (EntityAITasks.EntityAITaskEntry task : e.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAITempt)) continue;
                return;
            }
            e.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITemptFixed(e, 0.6, false, tempts.get(r)));
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        tempts = new HashMap<ResourceLocation, Set<ItemStack>>();
    }
}

