/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;

public class EntityAITemptFixed
extends EntityAITempt {
    public static int tickDelay;
    private final EntityLiving temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<ItemStack> temptItem;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptFixed(EntityLiving temptedEntityIn, double speedIn, Item temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, new ItemStack(temptItemIn));
    }

    public EntityAITemptFixed(EntityLiving temptedEntityIn, double speedIn, Set<Item> temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, temptItemIn.stream().map(ItemStack::new).collect(Collectors.toSet()));
    }

    public EntityAITemptFixed(EntityLiving temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, ItemStack temptItemIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, Sets.newHashSet((Object[])new ItemStack[]{temptItemIn}));
    }

    public EntityAITemptFixed(EntityLiving temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<ItemStack> temptItemIn) {
        super(temptedEntityIn instanceof EntityCreature ? (EntityCreature)temptedEntityIn : null, speedIn, scaredByPlayerMovementIn, null);
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.scaredByPlayerMovement = scaredByPlayerMovementIn;
        this.func_75248_a(3);
        if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_72890_a((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        return this.func_188508_a(this.temptingPlayer.func_184614_ca()) || this.func_188508_a(this.temptingPlayer.func_184592_cb());
    }

    protected boolean func_188508_a(ItemStack stack) {
        return this.temptItem.stream().filter(s -> s.func_77973_b() == stack.func_77973_b() && s.func_77960_j() == stack.func_77960_j()).findAny().isPresent();
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.field_70125_A - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.field_70177_z - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.field_70165_t;
                this.targetY = this.temptingPlayer.field_70163_u;
                this.targetZ = this.temptingPlayer.field_70161_v;
            }
            this.pitch = this.temptingPlayer.field_70125_A;
            this.yaw = this.temptingPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.field_70165_t;
        this.targetY = this.temptingPlayer.field_70163_u;
        this.targetZ = this.temptingPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = tickDelay;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.func_70661_as().func_75499_g();
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean func_75277_f() {
        return this.isRunning;
    }
}

