/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.render.IRenderBauble;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemModArmor;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.ProxiedItemStackHandler;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.oddities.client.model.ModelBackpack;
import vazkii.quark.oddities.feature.Backpacks;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles", striprefs=true)})
public class ItemBackpack
extends ItemModArmor
implements IBauble,
IQuarkItem,
IItemColorProvider,
IRenderBauble {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    private static final ResourceLocation WORN_TEXTURE_RL = new ResourceLocation("quark:textures/misc/backpack_worn.png");
    private static final ResourceLocation WORN_OVERLAY_TEXTURE_RL = new ResourceLocation("quark:textures/misc/backpack_worn_overlay.png");
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemBackpack.dispenseBackpack(source, stack);
            return itemstack.func_190926_b() ? super.func_82487_b(source, stack) : itemstack;
        }
    };
    public static ModelBackpack model;

    public ItemBackpack() {
        super("backpack", ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("has_items"), (stack, world, entity) -> !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack) ? 1.0f : 0.0f);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSER_BEHAVIOR);
    }

    public static ItemStack dispenseBackpack(IBlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.func_180699_d().func_177972_a((EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List list = blockSource.func_82618_k().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(blockpos), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new EntitySelectors.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(0);
        if (entitylivingbase instanceof EntityPlayer && Loader.isModLoaded((String)"baubles")) {
            EntityPlayer player = (EntityPlayer)entitylivingbase;
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if ((baubles.getStackInSlot(i) == null || baubles.getStackInSlot(i).func_190926_b()) && baubles.isItemValidForSlot(i, stack, (EntityLivingBase)player)) {
                    ItemStack splitstack = stack.func_77979_a(1);
                    baubles.setStackInSlot(i, splitstack);
                    if (splitstack.func_77973_b() instanceof IBauble) {
                        ((IBauble)splitstack.func_77973_b()).onEquipped(splitstack, (EntityLivingBase)player);
                    }
                    return stack;
                }
                if (baubles.getStackInSlot(i) == null || !(baubles.getStackInSlot(i).func_77973_b() instanceof ItemBackpack)) continue;
                return stack;
            }
        }
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)stack);
        ItemStack itemstack = stack.func_77979_a(1);
        entitylivingbase.func_184201_a(entityequipmentslot, itemstack);
        if (entitylivingbase instanceof EntityLiving) {
            ((EntityLiving)entitylivingbase).func_184642_a(entityequipmentslot, 2.0f);
        }
        return stack;
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (Loader.isModLoaded((String)"baubles")) {
                IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
                for (int i = 0; i < baubles.getSlots(); ++i) {
                    if (baubles.getStackInSlot(i) != null && !baubles.getStackInSlot(i).func_190926_b() || !baubles.isItemValidForSlot(i, stack, (EntityLivingBase)player)) continue;
                    baubles.setStackInSlot(i, stack.func_77946_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                    this.onEquipped(stack, (EntityLivingBase)player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)stack);
            ItemStack stackInSlot = player.func_184582_a(entityequipmentslot);
            if (stackInSlot.func_190926_b()) {
                player.func_184201_a(entityequipmentslot, stack.func_77946_l());
                stack.func_190920_e(stack.func_190916_E() - 1);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean hasItems = !Backpacks.superOpMode && ItemBackpack.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.field_190941_k);
        boolean changedEnchants = false;
        if (hasItems) {
            if (Backpacks.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.put(Enchantments.field_190941_k, 1);
                    changedEnchants = true;
                }
            } else {
                ItemStack copy = stack.func_77946_l();
                stack.func_190920_e(0);
                entityIn.func_70099_a(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.field_190941_k);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (Backpacks.superOpMode || entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack stack = entityItem.func_92059_d();
        if (!ItemNBTHelper.detectNBT((ItemStack)stack)) {
            return false;
        }
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            InventoryHelper.func_180173_a((World)entityItem.field_70170_p, (double)entityItem.field_70165_t, (double)entityItem.field_70163_u, (double)entityItem.field_70161_v, (ItemStack)copy);
        }
        NBTTagCompound comp = ItemNBTHelper.getNBT((ItemStack)stack);
        comp.func_82580_o("Inventory");
        if (comp.func_186856_d() == 0) {
            stack.func_77982_d(null);
        }
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (model == null) {
            model = new ModelBackpack();
        }
        return model;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound oldCapNbt) {
        ProxiedItemStackHandler handler = new ProxiedItemStackHandler(stack, 27);
        if (oldCapNbt != null && oldCapNbt.func_74764_b("Parent")) {
            NBTTagCompound itemData = oldCapNbt.func_74775_l("Parent");
            ItemStackHandler stacks = new ItemStackHandler();
            stacks.deserializeNBT(itemData);
            for (int i = 0; i < stacks.getSlots(); ++i) {
                handler.setStackInSlot(i, stacks.getStackInSlot(i));
            }
            oldCapNbt.func_82580_o("Parent");
        }
        return handler;
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, i) -> i == 1 ? ((ItemBackpack)stack.func_77973_b()).func_82814_b(stack) : -1;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.BODY;
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return !Backpacks.isEntityWearingBackpack((Entity)player, itemstack);
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return Backpacks.superOpMode || !ItemBackpack.doesBackpackHaveItems(itemstack);
    }

    public boolean func_82816_b_(@Nonnull ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("display", 10) && nbttagcompound.func_74775_l("display").func_150297_b("color", 3);
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound display;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (display = nbttagcompound.func_74775_l("display")).func_150297_b("color", 3)) {
            return display.func_74762_e("color");
        }
        return 10511680;
    }

    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="baubles")
    public void onPlayerBaubleRender(ItemStack itemStack, EntityPlayer player, IRenderBauble.RenderType renderType, float v) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (renderType != IRenderBauble.RenderType.BODY) {
            return;
        }
        if (model == null) {
            model = new ModelBackpack();
        }
        model.func_178686_a((ModelBase)new ModelPlayer(0.0f, false));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WORN_TEXTURE_RL);
        int i = Backpacks.backpack.func_82814_b(itemStack);
        float red = (float)(i >> 16 & 0xFF) / 255.0f;
        float green = (float)(i >> 8 & 0xFF) / 255.0f;
        float blue = (float)(i & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        float f = this.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialTicks);
        float f1 = this.interpolateRotation(player.field_70758_at, player.field_70759_as, partialTicks);
        float f2 = f1 - f;
        float f4 = 0.0625f;
        float f8 = (float)player.field_70173_aa + partialTicks;
        float f5 = player.field_184618_aE + (player.field_70721_aZ - player.field_184618_aE) * partialTicks;
        float f6 = player.field_184619_aG - player.field_70721_aZ * (1.0f - partialTicks);
        float f7 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        model.func_178719_a(false);
        ItemBackpack.model.field_78115_e.field_78806_j = true;
        model.func_78088_a((Entity)player, f6, f5, f8, f2, f7, f4);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(WORN_OVERLAY_TEXTURE_RL);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        model.func_78088_a((Entity)player, 0.0f, 0.0f, 1000.0f, 0.0f, 0.0f, 0.0625f);
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public EntityEquipmentSlot func_185083_B_() {
        return Loader.isModLoaded((String)"baubles") ? null : EntityEquipmentSlot.CHEST;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        if (stack.func_77973_b() instanceof ItemBackpack && entity instanceof EntityPlayer && Loader.isModLoaded((String)"baubles")) {
            return false;
        }
        return super.isValidArmor(stack, armorType, entity);
    }
}

