/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.feature;

import baubles.api.BaublesApi;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.InventoryIIH;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageHandleBackpack;
import vazkii.quark.oddities.RecipesBackpackDyes;
import vazkii.quark.oddities.client.gui.GuiBackpackInventory;
import vazkii.quark.oddities.item.ItemBackpack;

public class Backpacks
extends Feature {
    public static ItemBackpack backpack;
    public static boolean superOpMode;
    public static boolean enableTrades;
    public static boolean enableCrafting;
    public static boolean enablePickUp;
    public static int leatherCount;
    public static int minEmeralds;
    public static int maxEmeralds;
    @SideOnly(value=Side.CLIENT)
    public static boolean backpackRequested;
    private final Map<UUID, PickUpTask> pickUpQueue = new HashMap<UUID, PickUpTask>();
    private boolean processingPickUpQueue = false;

    @Override
    public void setupConfig() {
        enableTrades = this.loadPropBool("Enable Trade", "Set this to false if you want to disable the villager trade so you can add an alternate acquisition method", true);
        enableCrafting = this.loadPropBool("Enable Crafting", "Set this to true to enable a crafting recipe", false);
        enablePickUp = this.loadPropBool("Enable Backpack Pick-Up", "Set this to true to allow items to be picked up into backpacks when the main inventory is full", false);
        superOpMode = this.loadPropBool("Unbalanced Mode", "Set this to true to allow the backpacks to be unequipped even with items in them", false);
        leatherCount = this.loadPropInt("Required Leather", "", 12);
        minEmeralds = this.loadPropInt("Min Required Emeralds", "", 12);
        maxEmeralds = this.loadPropInt("Max Required Emeralds", "", 18);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        backpack = new ItemBackpack();
        if (enableCrafting) {
            RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack((Item)backpack), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('C'), "chestWood"});
        }
        new RecipesBackpackDyes();
    }

    @SubscribeEvent
    public void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (!enableTrades) {
            return;
        }
        VillagerRegistry.VillagerProfession butcher = (VillagerRegistry.VillagerProfession)event.getRegistry().getValue(new ResourceLocation("minecraft:butcher"));
        if (butcher != null) {
            VillagerRegistry.VillagerCareer leatherworker = butcher.getCareer(1);
            leatherworker.addTrade(1, new EntityVillager.ITradeList[]{new BackpackTrade()});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpenGUI(GuiOpenEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && Backpacks.isInventoryGUI(event.getGui()) && !player.func_184812_l_() && Backpacks.isEntityWearingBackpack((Entity)player)) {
            this.requestBackpack();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Backpacks.isInventoryGUI(mc.field_71462_r) && !backpackRequested && Backpacks.isEntityWearingBackpack((Entity)mc.field_71439_g)) {
            this.requestBackpack();
            backpackRequested = true;
        } else if (mc.field_71462_r instanceof GuiBackpackInventory) {
            backpackRequested = false;
        }
    }

    private void requestBackpack() {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageHandleBackpack(true));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void removeCurseTooltip(ItemTooltipEvent event) {
        if (!superOpMode && event.getItemStack().func_77973_b() instanceof ItemBackpack) {
            for (String s : event.getToolTip()) {
                if (!s.equals(Enchantments.field_190941_k.func_77316_c(1))) continue;
                event.getToolTip().remove(s);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void preItemPickUp(EntityItemPickupEvent event) {
        if (!enablePickUp || this.processingPickUpQueue) {
            return;
        }
        EntityItem item = event.getItem();
        if (item.field_70128_L || item.func_92059_d().func_190926_b()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!Backpacks.isEntityWearingBackpack((Entity)player)) {
            return;
        }
        this.pickUpQueue.computeIfAbsent((UUID)item.func_110124_au(), (Function<UUID, PickUpTask>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$preItemPickUp$0(net.minecraft.entity.item.EntityItem java.util.UUID ), (Ljava/util/UUID;)Lvazkii/quark/oddities/feature/Backpacks$PickUpTask;)((EntityItem)item)).players.add(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postItemPickUp(PlayerEvent.ItemPickupEvent event) {
        if (!enablePickUp || this.processingPickUpQueue) {
            return;
        }
        EntityItem item = event.getOriginalEntity();
        if (item.field_70128_L || item.func_92059_d().func_190926_b()) {
            this.pickUpQueue.remove(item.func_110124_au());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (!enablePickUp || event.phase != TickEvent.Phase.END) {
            return;
        }
        this.processingPickUpQueue = true;
        try {
            block3: for (PickUpTask task : this.pickUpQueue.values()) {
                for (EntityPlayer player : task.players) {
                    ItemStack stack;
                    if (task.item.field_70128_L || (stack = task.item.func_92059_d()).func_190926_b()) continue block3;
                    IItemHandlerModifiable inv = Backpacks.getBackpackInventory((Entity)player);
                    if (inv == null) continue;
                    ItemStack original = stack.func_77946_l();
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
                    if (remainder.func_190916_E() >= original.func_190916_E()) continue;
                    task.item.func_92058_a(remainder);
                    ItemStack transferred = ItemHandlerHelper.copyStackWithSize((ItemStack)original, (int)(original.func_190916_E() - remainder.func_190916_E()));
                    FMLCommonHandler.instance().firePlayerItemPickupEvent(player, task.item, transferred);
                    player.func_71064_a(StatList.func_188056_d((Item)original.func_77973_b()), transferred.func_190916_E());
                    if (!task.item.func_92059_d().func_190926_b()) continue;
                    player.func_71001_a((Entity)task.item, transferred.func_190916_E());
                    task.item.func_70106_y();
                    continue block3;
                }
            }
            this.pickUpQueue.clear();
        }
        finally {
            this.processingPickUpQueue = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isInventoryGUI(GuiScreen gui) {
        return gui != null && gui.getClass() == GuiInventory.class;
    }

    public static boolean isEntityWearingBackpack(Entity e) {
        if (Loader.isModLoaded((String)"baubles")) {
            if (e instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e;
                return BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)backpack) != -1;
            }
        } else if (e instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)e;
            ItemStack chestArmor = living.func_184582_a(EntityEquipmentSlot.CHEST);
            return chestArmor.func_77973_b() instanceof ItemBackpack;
        }
        return false;
    }

    public static boolean isEntityWearingBackpack(Entity e, ItemStack stack) {
        if (Loader.isModLoaded((String)"baubles")) {
            if (e instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e;
                return BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)stack.func_77973_b()) != -1;
            }
        } else if (e instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)e;
            ItemStack chestArmor = living.func_184582_a(EntityEquipmentSlot.CHEST);
            return chestArmor == stack;
        }
        return false;
    }

    @Nullable
    public static IItemHandlerModifiable getBackpackInventory(Entity e) {
        ItemStack stack = null;
        if (Loader.isModLoaded((String)"baubles")) {
            if (e instanceof EntityPlayer) {
                stack = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)e)).getStackInSlot(BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)e), (Item)backpack));
            }
        } else if (e instanceof EntityLivingBase) {
            stack = ((EntityLivingBase)e).func_184582_a(EntityEquipmentSlot.CHEST);
        }
        return stack != null && stack.func_77973_b() == backpack ? new InventoryIIH(stack) : null;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    private static /* synthetic */ PickUpTask lambda$preItemPickUp$0(EntityItem item, UUID k) {
        return new PickUpTask(item);
    }

    private static class PickUpTask {
        final EntityItem item;
        final List<EntityPlayer> players = new ArrayList<EntityPlayer>();

        PickUpTask(EntityItem item) {
            this.item = item;
        }
    }

    public static class BackpackTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            int emeraldCount = random.nextInt(maxEmeralds - minEmeralds) + minEmeralds;
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151116_aA, leatherCount), new ItemStack(Items.field_151166_bC, emeraldCount), new ItemStack((Item)backpack)));
        }
    }
}

