/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.arl.block.BlockModContainer;
import vazkii.quark.base.block.BlockQuarkWall;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.oddities.tile.TilePipe;

public class BlockPipe
extends BlockModContainer
implements IQuarkBlock {
    private static final AxisAlignedBB CENTER_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
    private static final AxisAlignedBB DOWN_FLARE_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.325, 0.75);
    private static final AxisAlignedBB UP_FLARE_AABB = new AxisAlignedBB(0.25, 0.625, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB NORTH_FLARE_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.325);
    private static final AxisAlignedBB SOUTH_FLARE_AABB = new AxisAlignedBB(0.25, 0.25, 0.625, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB WEST_FLARE_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.325, 0.75, 0.75);
    private static final AxisAlignedBB EAST_FLARE_AABB = new AxisAlignedBB(0.625, 0.25, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB DOWN_TERMINAL_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
    private static final AxisAlignedBB UP_TERMINAL_AABB = new AxisAlignedBB(0.25, 0.875, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB NORTH_TERMINAL_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.125);
    private static final AxisAlignedBB SOUTH_TERMINAL_AABB = new AxisAlignedBB(0.25, 0.25, 0.875, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB WEST_TERMINAL_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.125, 0.75, 0.75);
    private static final AxisAlignedBB EAST_TERMINAL_AABB = new AxisAlignedBB(0.875, 0.25, 0.25, 1.0, 0.75, 0.75);
    public static final PropertyEnum<ConnectionType> DOWN = PropertyEnum.func_177709_a((String)"down", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> UP = PropertyEnum.func_177709_a((String)"up", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> NORTH = PropertyEnum.func_177709_a((String)"north", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> SOUTH = PropertyEnum.func_177709_a((String)"south", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> WEST = PropertyEnum.func_177709_a((String)"west", ConnectionType.class);
    public static final PropertyEnum<ConnectionType> EAST = PropertyEnum.func_177709_a((String)"east", ConnectionType.class);
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    private static final PropertyEnum<ConnectionType>[] CONNECTIONS = new PropertyEnum[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final AxisAlignedBB[] SIDE_BOXES = new AxisAlignedBB[]{DOWN_AABB, UP_AABB, NORTH_AABB, SOUTH_AABB, WEST_AABB, EAST_AABB};
    private static final AxisAlignedBB[] FLARE_BOXES = new AxisAlignedBB[]{DOWN_FLARE_AABB, UP_FLARE_AABB, NORTH_FLARE_AABB, SOUTH_FLARE_AABB, WEST_FLARE_AABB, EAST_FLARE_AABB};
    private static final AxisAlignedBB[] TERMINAL_BOXES = new AxisAlignedBB[]{DOWN_TERMINAL_AABB, UP_TERMINAL_AABB, NORTH_TERMINAL_AABB, SOUTH_TERMINAL_AABB, WEST_TERMINAL_AABB, EAST_TERMINAL_AABB};
    private static final Map<IBlockState, EnumFacing> FLARE_STATES = Maps.newHashMap();

    public BlockPipe() {
        super("pipe", Material.field_151592_s, new String[0]);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.func_176223_P().func_177226_a(DOWN, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(UP, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(NORTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(SOUTH, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(WEST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a(EAST, (Comparable)((Object)ConnectionType.NONE)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)));
        block0: for (IBlockState state : this.field_176227_L.func_177619_a()) {
            EnumFacing onlySide = null;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (state.func_177229_b(CONNECTIONS[facing.func_176745_a()]) == ConnectionType.NONE) continue;
                if (onlySide != null) continue block0;
                onlySide = facing;
            }
            if (onlySide == null) continue;
            FLARE_STATES.put(state, onlySide.func_176734_d());
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)), 6);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        double minX = BlockPipe.connectionHeight(state, EnumFacing.WEST);
        double minY = BlockPipe.connectionHeight(state, EnumFacing.DOWN);
        double minZ = BlockPipe.connectionHeight(state, EnumFacing.NORTH);
        double maxX = BlockPipe.connectionHeight(state, EnumFacing.EAST);
        double maxY = BlockPipe.connectionHeight(state, EnumFacing.UP);
        double maxZ = BlockPipe.connectionHeight(state, EnumFacing.SOUTH);
        boolean downFlared = BlockPipe.isFlared(state, EnumFacing.DOWN);
        boolean upFlared = BlockPipe.isFlared(state, EnumFacing.UP);
        boolean northFlared = BlockPipe.isFlared(state, EnumFacing.NORTH);
        boolean southFlared = BlockPipe.isFlared(state, EnumFacing.SOUTH);
        boolean westFlared = BlockPipe.isFlared(state, EnumFacing.WEST);
        boolean eastFlared = BlockPipe.isFlared(state, EnumFacing.EAST);
        if (downFlared || upFlared || northFlared || southFlared) {
            maxX = Math.max(maxX, 0.75);
            minX = Math.min(minX, 0.25);
        }
        if (northFlared || southFlared || westFlared || eastFlared) {
            maxY = Math.max(maxY, 0.75);
            minY = Math.min(minY, 0.25);
        }
        if (downFlared || upFlared || westFlared || eastFlared) {
            maxZ = Math.max(maxZ, 0.75);
            minZ = Math.min(minZ, 0.25);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        this.func_185477_a(blockState, worldIn, pos, new AxisAlignedBB(pos), boxes, null, false);
        for (AxisAlignedBB bb : boxes) {
            if (this.func_185503_a(pos, start, end, bb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()))) == null) continue;
            return super.func_180636_a(blockState, worldIn, pos, start, end);
        }
        return null;
    }

    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CENTER_AABB);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            ConnectionType type = BlockPipe.getType(state, side);
            if (type != null && type.isSolid) {
                BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_BOXES[side.ordinal()]);
            }
            if (type == null) {
                BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FLARE_BOXES[side.ordinal()]);
                continue;
            }
            if (type != ConnectionType.TERMINAL) continue;
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TERMINAL_BOXES[side.ordinal()]);
        }
    }

    public static double connectionHeight(IBlockState state, EnumFacing side) {
        ConnectionType type = BlockPipe.getType(state, side);
        int direction = side.func_176743_c().func_179524_a();
        double base = 0.5 + 0.1875 * (double)direction;
        return base + (double)direction * (type != null && type.isSolid ? 0.3125 : (type == null || type.isFlared ? 0.0625 : 0.0));
    }

    public static boolean isFlared(IBlockState state, EnumFacing side) {
        ConnectionType type = BlockPipe.getType(state, side);
        return type == null || type.isFlared;
    }

    public static ConnectionType getType(IBlockState state, EnumFacing side) {
        if (FLARE_STATES.containsKey(state) && FLARE_STATES.get(state) == side) {
            return null;
        }
        PropertyEnum<ConnectionType> prop = CONNECTIONS[side.ordinal()];
        return (ConnectionType)((Object)state.func_177229_b(prop));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IProperty<?>[] getIgnoredProperties() {
        return new IProperty[]{ENABLED};
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, SOUTH, WEST, EAST, ENABLED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 0 : 1;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 1) != 1));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = state;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            PropertyEnum<ConnectionType> prop = CONNECTIONS[facing.ordinal()];
            ConnectionType type = this.getConnectionTo(worldIn, pos, facing);
            actualState = actualState.func_177226_a(prop, (Comparable)((Object)type));
        }
        return actualState;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TilePipe) {
            return ((TilePipe)tile).getComparatorOutput();
        }
        return 0;
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TilePipe) {
            ((TilePipe)tileentity).dropAllItems();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePipe();
    }

    private ConnectionType getConnectionTo(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile;
        pos = pos.func_177972_a(face);
        TileEntity tileEntity = tile = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof TilePipe) {
                return ConnectionType.PIPE;
            }
            if (tile instanceof IInventory || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d()) != null) {
                return ConnectionType.TERMINAL;
            }
        }
        IBlockState stateAt = world.func_180495_p(pos);
        Block blockAt = stateAt.func_177230_c();
        if (face.func_176740_k() == EnumFacing.Axis.Y && (blockAt instanceof BlockWall || blockAt instanceof BlockQuarkWall) || (blockAt instanceof BlockPistonBase || blockAt instanceof BlockPistonExtension) && stateAt.func_177229_b((IProperty)BlockDirectional.field_176387_N) == face.func_176734_d()) {
            return ConnectionType.PROP;
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NONE(false, false, false),
        PIPE(true, true, false),
        TERMINAL(true, true, true),
        PROP(true, false, false);

        public final boolean isSolid;
        public final boolean allowsItems;
        public final boolean isFlared;

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
            this.isFlared = isFlared;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

