/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.features;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockModSlab;
import vazkii.quark.base.module.Feature;
import vazkii.quark.experimental.block.BlockFramed;
import vazkii.quark.experimental.block.BlockFramedSlab;
import vazkii.quark.experimental.client.model.FramedBlockModel;
import vazkii.quark.experimental.tile.TileFramed;

public class FramedBlocks
extends Feature {
    public static Block frame;
    public static BlockModSlab frameSlab;
    public static BlockModSlab frameSlabDouble;

    public static boolean setFrame(World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand) {
        TileFramed tile = (TileFramed)worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemBlock && tile != null) {
            tile.func_70299_a(0, stack.func_77946_l());
        }
        worldIn.func_175704_b(pos, pos);
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        frame = new BlockFramed();
        frameSlab = new BlockFramedSlab(false);
        frameSlabDouble = new BlockFramedSlab(true);
        BlockModSlab.initSlab((Block)frame, (int)0, (BlockModSlab)frameSlab, (BlockModSlab)frameSlabDouble);
        FramedBlocks.registerTile(TileFramed.class, "framed");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        this.applyCustomModel(event, "frame", "normal");
        this.applyCustomModel(event, "frame_slab", "half=top");
        this.applyCustomModel(event, "frame_slab", "half=bottom");
        this.applyCustomModel(event, "frame_slab", "normal");
        this.applyCustomModel(event, "frame_slab_double", "normal");
        this.applyCustomModel(event, "frame_slab_double", "prop=blarg");
    }

    private void applyCustomModel(ModelBakeEvent event, String modelName, String prop) {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("quark", modelName), prop);
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
        IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        FramedBlockModel finalModel = new FramedBlockModel(standard, model);
        event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

