/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;

public class TextureDump
extends Feature {
    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post e) {
        this.saveGlTexture(e.getMap().field_94254_c, e.getMap().func_110552_b(), e.getMap().field_147636_j);
    }

    @SideOnly(value=Side.CLIENT)
    private void saveGlTexture(String name, int textureId, int mipmapLevels) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        File instanceDirectory = Minecraft.func_71410_x().field_71412_D;
        for (int level = 0; level < mipmapLevels; ++level) {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
            int size = width * height;
            BufferedImage image = new BufferedImage(width, height, 2);
            IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
            int[] data = new int[size];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buffer);
            buffer.get(data);
            image.setRGB(0, 0, width, height, data, 0, width);
            try {
                File output = new File(instanceDirectory, name + "_" + level + ".png").getCanonicalFile();
                ImageIO.write((RenderedImage)image, "png", output);
                Quark.LOG.info("[TextureDump] Exported atlas to: " + output.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                Quark.LOG.info("[TextureDump] Unable to write: ", (Throwable)e);
            }
        }
    }
}

