/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.util.ItemMetaHelper;

public class GlowingItems
extends Feature {
    public static double maxDistance;
    public static final Map<ResourceLocation, TIntSet> glowingItems;

    @Override
    public void setupConfig() {
        glowingItems.clear();
        String[] tempGlowingItems = this.loadPropStringList("Glowing Items", "Items that should glow when near the player\nFormat is modid:item[:meta]", new String[0]);
        for (ItemStack stack : ItemMetaHelper.getFromStringArray("glowing item", tempGlowingItems)) {
            glowingItems.computeIfAbsent(stack.func_77973_b().getRegistryName(), k -> new TIntHashSet()).add(stack.func_77960_j());
        }
        maxDistance = this.loadPropDouble("Maximum Distance", "The maximum distance from the player at which items will glow. Default is 32 blocks", 32.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isOutlineActive(Entity entity, Entity viewer) {
        if (!(entity instanceof EntityItem) || !ModuleLoader.isFeatureEnabled(GlowingItems.class)) {
            return false;
        }
        ItemStack stack = ((EntityItem)entity).func_92059_d();
        if (stack.func_190926_b()) {
            return false;
        }
        TIntSet metas = glowingItems.get(stack.func_77973_b().getRegistryName());
        return metas != null && metas.contains(stack.func_77960_j()) && viewer.func_70068_e(entity) <= maxDistance * maxDistance;
    }

    static {
        glowingItems = new HashMap<ResourceLocation, TIntSet>();
    }
}

