/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class BeaconReplacementHandler {
    private static Potion[][] defaultEffectsList = null;
    private static List<Replacer> replacers;

    public static void parse(String[] lines) {
        replacers = Arrays.stream(lines).map(x$0 -> Replacer.fromString(x$0)).filter(r -> r != null).collect(Collectors.toList());
        BeaconReplacementHandler.commit();
    }

    private static void commit() {
        if (defaultEffectsList == null) {
            defaultEffectsList = new Potion[TileEntityBeacon.field_146009_a.length][2];
            for (int i = 0; i < TileEntityBeacon.field_146009_a.length; ++i) {
                Potion[] a = TileEntityBeacon.field_146009_a[i];
                for (int j = 0; j < a.length && j < defaultEffectsList[i].length; ++j) {
                    BeaconReplacementHandler.defaultEffectsList[i][j] = a[j];
                }
            }
        }
        for (Replacer r : replacers) {
            TileEntityBeacon.field_184280_f.add(r.potion);
        }
    }

    public static void update(TileEntityBeacon beacon) {
        for (int i = 0; i < TileEntityBeacon.field_146009_a.length; ++i) {
            Potion[] a = TileEntityBeacon.field_146009_a[i];
            for (int j = 0; j < a.length && j < defaultEffectsList[i].length; ++j) {
                a[j] = defaultEffectsList[i][j];
            }
        }
        BlockPos pos = beacon.func_174877_v();
        World world = beacon.func_145831_w();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                BlockPos targetPos = pos.func_177982_a(i, 0, j);
                IBlockState state = world.func_180495_p(targetPos);
                replacers.forEach(r -> r.replace(state));
            }
        }
    }

    private static class Replacer {
        private final Block block;
        private final int meta;
        private final int layer;
        private final int effect;
        private final Potion potion;

        public Replacer(Block block, int meta, int layer, int effect, Potion potion) {
            this.block = block;
            this.meta = meta;
            this.layer = layer;
            this.effect = effect;
            this.potion = potion;
        }

        private static Replacer fromString(String s) {
            String[] tokens = s.split(",");
            if (tokens.length != 5) {
                return null;
            }
            Block block = Block.func_149684_b((String)tokens[0]);
            int meta = MathHelper.func_82715_a((String)tokens[1], (int)-1);
            int layer = MathHelper.func_82715_a((String)tokens[2], (int)-1);
            int effect = MathHelper.func_82715_a((String)tokens[3], (int)(layer == 2 || layer == 3 ? 0 : -1));
            Potion potion = Potion.func_180142_b((String)tokens[4]);
            if (potion == null || effect < 0 || effect > 1 || layer < 0 || layer > 3) {
                return null;
            }
            return new Replacer(block, meta, layer, effect, potion);
        }

        public void replace(IBlockState stateAt) {
            if ((this.block == null || stateAt.func_177230_c() == this.block && (this.meta == -1 || this.block.func_176201_c(stateAt) == this.meta)) && this.layer < TileEntityBeacon.field_146009_a.length && this.effect < TileEntityBeacon.field_146009_a[this.layer].length) {
                TileEntityBeacon.field_146009_a[this.layer][this.effect] = this.potion;
            }
        }
    }
}

