/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.Feature;

public class DispensersPlaceSeeds
extends Feature {
    public static String[] customSeedsArr;
    public static Map<Item, IBlockState> customSeeds;

    @Override
    public void setupConfig() {
        ConfigHelper.needsRestart = true;
        customSeedsArr = this.loadPropStringList("Custom Seeds", "Add seeds from other mods here, in the following format: mod:seed=mod:block[:meta].", new String[0]);
    }

    @Override
    public void init() {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151014_N, (Object)new BehaviourSeeds(Blocks.field_150464_aj));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151174_bG, (Object)new BehaviourSeeds(Blocks.field_150469_bN));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151172_bF, (Object)new BehaviourSeeds(Blocks.field_150459_bM));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151075_bm, (Object)new BehaviourSeeds(Blocks.field_150388_bm));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151080_bb, (Object)new BehaviourSeeds(Blocks.field_150393_bb));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151081_bc, (Object)new BehaviourSeeds(Blocks.field_150394_bc));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_185163_cU, (Object)new BehaviourSeeds(Blocks.field_185773_cZ));
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)Blocks.field_185766_cS), (Object)new BehaviourSeeds(Blocks.field_185766_cS));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151100_aR, (Object)new BehaviourCocoaBeans((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151100_aR)));
        this.setupCustomSeeds();
    }

    public void setupCustomSeeds() {
        customSeeds = new HashMap<Item, IBlockState>();
        for (String s : customSeedsArr) {
            Block block;
            String[] tokens = s.split("=");
            if (tokens.length != 2) continue;
            String key = tokens[0];
            String value = tokens[1];
            Item item = Item.func_111206_d((String)key);
            if (item == null) continue;
            tokens = value.split(":");
            int meta = -1;
            if (tokens.length == 3) {
                meta = MathHelper.func_82715_a((String)tokens[2], (int)-1);
            }
            if ((block = Block.func_149684_b((String)(value = tokens[0] + ":" + tokens[1]))) == null) continue;
            if (meta == -1) {
                customSeeds.put(item, block.func_176223_P());
                continue;
            }
            customSeeds.put(item, block.func_176203_a(meta));
        }
        for (Item i : customSeeds.keySet()) {
            BlockDispenser.field_149943_a.func_82595_a((Object)i, (Object)new BehaviourSeeds(customSeeds.get(i)));
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"botania", "animania"};
    }

    public class BehaviourCocoaBeans
    extends Bootstrap.BehaviorDispenseOptional {
        private final IBehaviorDispenseItem vanillaBehaviour;

        public BehaviourCocoaBeans(IBehaviorDispenseItem vanilla) {
            this.vanillaBehaviour = vanilla;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            this.field_190911_b = false;
            if (stack.func_77952_i() == EnumDyeColor.BROWN.func_176767_b()) {
                BlockPos logPos;
                Block block = Blocks.field_150375_by;
                EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                BlockPos pos = source.func_180699_d().func_177972_a(facing);
                World world = source.func_82618_k();
                IBlockState logState = world.func_180495_p(logPos = pos.func_177972_a(facing));
                if (logState.func_177230_c() == Blocks.field_150364_r && logState.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE && world.func_175623_d(pos) && block.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
                    stack.func_190918_g(1);
                    this.field_190911_b = true;
                    return stack;
                }
            }
            ItemStack out = this.vanillaBehaviour.func_82482_a(source, stack);
            if (this.vanillaBehaviour instanceof Bootstrap.BehaviorDispenseOptional) {
                this.field_190911_b = ((Bootstrap.BehaviorDispenseOptional)this.vanillaBehaviour).field_190911_b;
            }
            return out;
        }
    }

    public class BehaviourSeeds
    extends Bootstrap.BehaviorDispenseOptional {
        private final IBlockState placeState;

        public BehaviourSeeds(Block block) {
            this(block.func_176223_P());
        }

        public BehaviourSeeds(IBlockState state) {
            this.placeState = state;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            World world = source.func_82618_k();
            this.field_190911_b = false;
            if (world.func_175623_d(pos) && this.placeState.func_177230_c().func_176196_c(world, pos)) {
                world.func_175656_a(pos, this.placeState);
                stack.func_190918_g(1);
                this.field_190911_b = true;
                return stack;
            }
            return stack;
        }
    }
}

