/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.handlers.entities;

import funwayguy.epicsiegemod.config.EsmConfigGlobal;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerHandler {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayer) || !(event.getEntity().field_70170_p instanceof WorldServer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        int day = (int)(player.field_70170_p.func_72820_D() / 24000L);
        boolean hard = EsmConfigGlobal.hardDay != 0 && day != 0 && day % EsmConfigGlobal.hardDay == 0;
        Random rand = player.func_70681_au();
        if (hard && rand.nextInt(10) == 0 && player.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && player.field_70170_p.func_82736_K().func_82766_b("doMobSpawning") && player.field_70170_p.field_72996_f.size() < 512) {
            Biome.SpawnListEntry spawnlistentry;
            int x = MathHelper.func_76128_c((double)player.field_70165_t) + rand.nextInt(48) - 24;
            int y = MathHelper.func_76128_c((double)player.field_70163_u) + rand.nextInt(48) - 24;
            int z = MathHelper.func_76128_c((double)player.field_70161_v) + rand.nextInt(48) - 24;
            BlockPos spawnPos = new BlockPos(x, y, z);
            if (player.field_70170_p.func_184137_a((double)x, (double)y, (double)z, 8.0, false) == null && WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)player.field_70170_p, (BlockPos)spawnPos) && (spawnlistentry = ((WorldServer)player.field_70170_p).func_175734_a(EnumCreatureType.MONSTER, spawnPos)) != null) {
                try {
                    EntityLiving entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(player.field_70170_p);
                    entityliving.func_70012_b((double)x, (double)y, (double)z, rand.nextFloat() * 360.0f, 0.0f);
                    Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)player.field_70170_p, (float)x, (float)y, (float)z, null);
                    if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi()) {
                        player.field_70170_p.func_72838_d((Entity)entityliving);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerLoggedInEvent event) {
        if (EsmConfigGlobal.ResistanceCoolDown > 0) {
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, EsmConfigGlobal.ResistanceCoolDown, 5));
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EsmConfigGlobal.ResistanceCoolDown > 0) {
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, EsmConfigGlobal.ResistanceCoolDown, 5));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EsmConfigGlobal.ResistanceCoolDown > 0) {
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, EsmConfigGlobal.ResistanceCoolDown, 5));
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (EsmConfigGlobal.AllowSleep || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityPlayer().func_70608_bn() || !event.getEntityPlayer().func_70089_S()) {
            return;
        }
        if ((!event.getEntityPlayer().field_70170_p.field_73011_w.func_76567_e() || event.getEntityPlayer().field_70170_p.func_72935_r()) && (Math.abs(event.getEntityPlayer().field_70165_t - (double)event.getPos().func_177958_n()) > 3.0 || Math.abs(event.getEntityPlayer().field_70163_u - (double)event.getPos().func_177956_o()) > 2.0 || Math.abs(event.getEntityPlayer().field_70161_v - (double)event.getPos().func_177952_p()) > 3.0)) {
            return;
        }
        double xOff = 8.0;
        double yOff = 5.0;
        List list = event.getEntityPlayer().field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB((double)event.getPos().func_177958_n() - xOff, (double)event.getPos().func_177956_o() - yOff, (double)event.getPos().func_177952_p() - xOff, (double)event.getPos().func_177958_n() + xOff, (double)event.getPos().func_177956_o() + yOff, (double)event.getPos().func_177952_p() + xOff));
        if (!list.isEmpty()) {
            return;
        }
        event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        if (event.getEntityPlayer().func_184218_aH()) {
            event.getEntityPlayer().func_184210_p();
        }
        event.getEntityPlayer().setSpawnChunk(event.getPos(), false, event.getEntityPlayer().field_71093_bK);
        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Spawnpoint set"));
    }
}

