/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import funwayguy.epicsiegemod.config.CfgProperty;
import funwayguy.epicsiegemod.config.JsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class CfgPropList<T>
extends CfgProperty<List<T>> {
    public CfgPropList(String key, List<T> def, Function<JsonElement, T> funcGet, Function<T, JsonElement> funcSet) {
        super(key, def, (JsonObject json) -> CfgPropList.readList(key, json, funcGet), (JsonObject json, T value) -> CfgPropList.writeList(key, json, value, funcSet));
    }

    private static <T> List<T> readList(String key, JsonObject json, Function<JsonElement, T> funcGet) {
        JsonArray ary = JsonHelper.getArray(json, key);
        if (ary.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ary.forEach(e -> {
            if (e == null) {
                return;
            }
            Object value = funcGet.apply((JsonElement)e);
            if (value != null) {
                list.add(value);
            }
        });
        return list;
    }

    private static <T> void writeList(String key, JsonObject json, List<T> list, Function<T, JsonElement> funcSet) {
        JsonArray ary = new JsonArray();
        list.forEach(val -> {
            if (val == null) {
                return;
            }
            JsonElement e = (JsonElement)funcSet.apply(val);
            if (e != null) {
                ary.add(e);
            }
        });
        json.add(key, (JsonElement)ary);
    }

    public static CfgPropList<String> asString(String key, List<String> def) {
        return new CfgPropList<String>(key, def, json -> {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
                return "";
            }
            return json.getAsString();
        }, JsonPrimitive::new);
    }

    public static CfgPropList<Number> asNumber(String key, List<Number> def) {
        return new CfgPropList<Number>(key, def, json -> {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) {
                return 0;
            }
            return json.getAsNumber();
        }, JsonPrimitive::new);
    }

    public static CfgPropList<ResourceLocation> asResource(String key, List<ResourceLocation> def) {
        return new CfgPropList<ResourceLocation>(key, def, json -> {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
                return null;
            }
            try {
                return new ResourceLocation(json.getAsString());
            }
            catch (Exception ignored) {
                return null;
            }
        }, res -> new JsonPrimitive(res.toString()));
    }
}

