/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import funwayguy.epicsiegemod.core.ESM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class JsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonArray getArray(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getArray(json, key, JsonArray::new);
    }

    public static JsonArray getArray(@Nonnull JsonObject json, @Nonnull String key, Supplier<JsonArray> def) {
        JsonElement je = json.get(key);
        return je instanceof JsonArray ? je.getAsJsonArray() : def.get();
    }

    public static JsonObject getObject(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getObject(json, key, JsonObject::new);
    }

    public static JsonObject getObject(@Nonnull JsonObject json, @Nonnull String key, Supplier<JsonObject> def) {
        JsonElement je = json.get(key);
        return je instanceof JsonObject ? je.getAsJsonObject() : def.get();
    }

    public static String getString(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getString(json, key, "");
    }

    public static String getString(@Nonnull JsonObject json, @Nonnull String key, String def) {
        JsonElement je = json.get(key);
        return je instanceof JsonPrimitive && je.getAsJsonPrimitive().isString() ? je.getAsString() : def;
    }

    public static Number getNumber(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getNumber(json, key, 0);
    }

    public static Number getNumber(@Nonnull JsonObject json, @Nonnull String key, Number def) {
        JsonElement je = json.get(key);
        try {
            return je instanceof JsonPrimitive ? (Number)je.getAsNumber() : (Number)def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean getBoolean(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getBoolean(json, key, false);
    }

    public static boolean getBoolean(@Nonnull JsonObject json, @Nonnull String key, boolean def) {
        JsonElement je = json.get(key);
        try {
            return je instanceof JsonPrimitive ? je.getAsBoolean() : def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static JsonElement getElement(@Nonnull JsonObject json, @Nonnull String key) {
        return JsonHelper.getElement(json, key, () -> JsonNull.INSTANCE);
    }

    public static JsonElement getElement(@Nonnull JsonObject json, @Nonnull String key, @Nonnull Supplier<JsonElement> def) {
        JsonElement je = json.get(key);
        return je != null ? je : def.get();
    }

    public static JsonObject readFromFile(@Nonnull File file) {
        return JsonHelper.readFromFile(file, JsonObject.class, JsonObject::new);
    }

    public static <T extends JsonElement> T readFromFile(@Nonnull File file, Class<T> cls, @Nonnull Supplier<T> def) {
        JsonElement json;
        if (!file.exists()) {
            return (T)((JsonElement)def.get());
        }
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
            json = (JsonElement)GSON.fromJson((Reader)isr, cls);
        }
        catch (Exception e) {
            ESM.logger.warn("An error occured while loading JsonObject from file:", (Throwable)e);
            json = (JsonElement)def.get();
        }
        return (T)json;
    }

    public static void writeToFile(@Nonnull File file, JsonElement json) {
        Throwable throwable;
        Throwable throwable2;
        File tmp = new File(file.getAbsolutePath() + ".tmp");
        try {
            if (tmp.exists()) {
                if (!tmp.delete()) {
                    throw new IOException("Unable to delete old temp file!");
                }
            } else if (tmp.getParentFile() != null && !tmp.getParentFile().exists() && !tmp.getParentFile().mkdirs()) {
                throw new IOException("Unable to create parent directory!");
            }
        }
        catch (IOException e) {
            ESM.logger.warn("An error occured while writing JSON to file (Directory Setup): " + e);
            return;
        }
        try {
            throwable2 = null;
            try (FileOutputStream fos = new FileOutputStream(tmp);){
                throwable = null;
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                    GSON.toJson(json, (Appendable)osw);
                    osw.flush();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable osw) {
                throwable2 = osw;
                throw osw;
            }
        }
        catch (IOException e) {
            ESM.logger.warn("An error occured while writing JSON to file (File Write): " + e);
            return;
        }
        try {
            throwable2 = null;
            try (FileInputStream fis = new FileInputStream(tmp);){
                throwable = null;
                try (InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                    GSON.fromJson((Reader)isr, json.getClass());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            ESM.logger.warn("An error occured while writing JSON to file (Validation Check): " + e);
            return;
        }
        try {
            if (file.exists() && !file.delete()) {
                throw new IOException("Failed to delete old file!");
            }
            if (!tmp.renameTo(file)) {
                throw new IOException("Failed to rename temp file!");
            }
        }
        catch (IOException e) {
            ESM.logger.warn("An error occured while writing JSON to file (Temp Copy): " + e);
        }
    }

    public static void copyTo(File fileIn, File fileOut) {
        if (!fileIn.exists()) {
            return;
        }
        if (fileOut.getParentFile() != null) {
            fileOut.getParentFile().mkdirs();
        }
        try {
            Files.copy(fileIn.toPath(), fileOut.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ESM.logger.warn("Error occured while coping file (" + fileIn + ") to (" + fileOut + "):", (Throwable)e);
        }
    }

    public static void createBackup(File file, String prefix) {
        String name = prefix + "_" + file.getName();
        String ext = JsonHelper.getExtension(file);
        String par = file.getParent();
        File bkup = new File(par, name + ext);
        int i = 0;
        while (bkup.exists()) {
            bkup = new File(par, name + "_" + i++ + ext);
        }
        ESM.logger.warn("Creating backup at: " + bkup.getAbsolutePath());
        JsonHelper.copyTo(file, bkup);
    }

    public static String getExtension(File file) {
        String fullName = file.getAbsolutePath();
        int idx = fullName.lastIndexOf(46);
        return idx >= 0 ? fullName.substring(idx) : "";
    }
}

