/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import funwayguy.epicsiegemod.config.JsonHelper;
import funwayguy.epicsiegemod.config.props.CfgProps;
import funwayguy.epicsiegemod.core.ESM;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class EsmJsonConfig {
    private EsmJsonConfig parentSet = null;
    private final Map<ResourceLocation, JsonObject> MAIN_CONFIG = new HashMap<ResourceLocation, JsonObject>();
    @Deprecated
    private final JsonObject DEF_CONFIG = new JsonObject();
    private static final Gson GSON = new GsonBuilder().create();

    public EsmJsonConfig setParentSet(EsmJsonConfig set) {
        this.parentSet = set;
        return this;
    }

    public JsonObject getOrCreate(@Nullable ResourceLocation idName) {
        return this.MAIN_CONFIG.computeIfAbsent(idName, id -> new JsonObject());
    }

    public JsonObject get(@Nullable ResourceLocation idName) {
        JsonObject json = this.MAIN_CONFIG.get(idName);
        return json != null ? json : this.MAIN_CONFIG.get(null);
    }

    public void clear() {
        this.MAIN_CONFIG.clear();
    }

    public int size() {
        return this.MAIN_CONFIG.size();
    }

    public void readJson(JsonObject json) {
        this.clear();
        JsonObject jEnt = JsonHelper.getObject(json, "entities");
        jEnt.entrySet().forEach(entry -> {
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                return;
            }
            try {
                this.MAIN_CONFIG.put(new ResourceLocation((String)entry.getKey()), EsmJsonConfig.deepJsonCopy(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            catch (Exception e) {
                ESM.logger.error("Unabled to parse entity ID: " + (String)entry.getKey(), (Throwable)e);
            }
        });
        this.MAIN_CONFIG.put(null, EsmJsonConfig.deepJsonCopy(JsonHelper.getObject(json, "default")));
    }

    public JsonObject writeJson(JsonObject json) {
        JsonObject jEnt = new JsonObject();
        this.MAIN_CONFIG.forEach((key, subset) -> {
            JsonObject temp = new JsonObject();
            subset.entrySet().forEach(entry -> temp.add((String)entry.getKey(), EsmJsonConfig.deepJsonCopy((JsonElement)entry.getValue())));
            if (key == null) {
                json.add("default", (JsonElement)temp);
            } else {
                jEnt.add(key.toString(), (JsonElement)temp);
            }
        });
        json.add("entities", (JsonElement)jEnt);
        return json;
    }

    public EsmJsonConfig copyInto(EsmJsonConfig dest) {
        dest.readJson(this.writeJson(new JsonObject()));
        return dest;
    }

    public void resetToDefault() {
        this.clear();
        CfgProps.resetAllConfigs();
    }

    private static <T extends JsonElement> T deepJsonCopy(T src) {
        try {
            return (T)((JsonElement)GSON.fromJson(GSON.toJson(src), src.getClass()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

