/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai;

import funwayguy.epicsiegemod.ai.utils.AiUtils;
import funwayguy.epicsiegemod.config.props.CfgProps;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ESM_EntityAIDigging
extends EntityAIBase {
    private EntityLivingBase target;
    private EntityLiving digger;
    private BlockPos curBlock;
    private int scanTick = 0;
    private int digTick = 0;
    private BlockPos obsPos = null;
    private int obsTick = 0;

    public ESM_EntityAIDigging(EntityLiving digger) {
        this.digger = digger;
    }

    public boolean func_75250_a() {
        this.target = this.digger.func_70638_az();
        if (this.target == null || !this.target.func_70089_S() || !this.digger.func_70661_as().func_75500_f()) {
            return false;
        }
        double dist = this.digger.func_70068_e((Entity)this.target);
        double navDist = this.digger.func_70661_as().func_111269_d();
        if (dist < 1.0 || dist > navDist * navDist) {
            return false;
        }
        if (this.obsPos == null) {
            this.obsPos = this.digger.func_180425_c();
        }
        if (!this.obsPos.equals((Object)this.digger.func_180425_c())) {
            this.obsTick = 0;
            this.obsPos = null;
            return false;
        }
        if (++this.obsTick < 20) {
            return false;
        }
        this.curBlock = this.curBlock != null && this.digger.func_174818_b(this.curBlock) <= 16.0 && this.canHarvest(this.digger, this.curBlock) ? this.curBlock : this.getNextBlock(this.digger, this.target, 2.0);
        return this.curBlock != null;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.digger.func_70661_as().func_75499_g();
        this.obsTick = 0;
        this.obsPos = null;
    }

    public void func_75251_c() {
        this.curBlock = null;
        this.digTick = 0;
        this.obsTick = 0;
        this.obsPos = null;
    }

    public boolean func_75253_b() {
        return this.target != null && this.curBlock != null && this.digger.func_174818_b(this.curBlock) <= 16.0 && this.canHarvest(this.digger, this.curBlock);
    }

    public void func_75246_d() {
        this.digger.func_70671_ap().func_75650_a(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v, (float)this.digger.func_184649_cE(), (float)this.digger.func_70646_bf());
        this.digger.func_70661_as().func_75499_g();
        ++this.digTick;
        float str = AiUtils.getBlockStrength((EntityLivingBase)this.digger, this.digger.field_70170_p, this.curBlock) * ((float)this.digTick + 1.0f);
        ItemStack heldItem = this.digger.func_184586_b(EnumHand.MAIN_HAND);
        IBlockState state = this.digger.field_70170_p.func_180495_p(this.curBlock);
        if (this.digger.field_70170_p.func_175623_d(this.curBlock)) {
            this.func_75251_c();
        } else if (str >= 1.0f) {
            boolean canHarvest = state.func_185904_a().func_76229_l() || !heldItem.func_190926_b() && heldItem.func_150998_b(state);
            this.digger.field_70170_p.func_175655_b(this.curBlock, false);
            if (canHarvest && this.digger.field_70170_p instanceof WorldServer) {
                FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.digger.field_70170_p));
                player.func_184611_a(EnumHand.MAIN_HAND, heldItem);
                player.func_184611_a(EnumHand.OFF_HAND, this.digger.func_184586_b(EnumHand.OFF_HAND));
                player.func_70107_b((double)this.digger.func_180425_c().func_177958_n(), (double)this.digger.func_180425_c().func_177956_o(), (double)this.digger.func_180425_c().func_177952_p());
                TileEntity tile = this.digger.field_70170_p.func_175625_s(this.curBlock);
                state.func_177230_c().func_180657_a(this.digger.field_70170_p, (EntityPlayer)player, this.curBlock, state, tile, heldItem);
            }
            this.digger.func_70661_as().func_75484_a(this.digger.func_70661_as().func_75494_a((Entity)this.target), this.digger.func_70605_aq().func_75638_b());
            this.func_75251_c();
        } else if (this.digTick % 5 == 0) {
            this.digger.field_70170_p.func_184133_a(null, this.curBlock, state.func_177230_c().getSoundType(state, this.digger.field_70170_p, this.curBlock, (Entity)this.digger).func_185846_f(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.digger.func_184609_a(EnumHand.MAIN_HAND);
            this.digger.field_70170_p.func_175715_c(this.digger.func_145782_y(), this.curBlock, (int)(str * 10.0f));
        }
    }

    private BlockPos getNextBlock(EntityLiving entityLiving, EntityLivingBase target, double dist) {
        BlockPos p2;
        int digHeight;
        int digWidth = MathHelper.func_76123_f((float)entityLiving.field_70130_N);
        int passMax = digWidth * digWidth * (digHeight = MathHelper.func_76123_f((float)entityLiving.field_70131_O));
        if (passMax <= 0) {
            return null;
        }
        int y = this.scanTick % digHeight;
        int x = this.scanTick % (digWidth * digHeight) / digHeight;
        int z = this.scanTick / (digWidth * digHeight);
        double rayX = (double)x + Math.floor(entityLiving.field_70165_t) + 0.5 - (double)digWidth / 2.0;
        double rayY = (double)y + Math.floor(entityLiving.field_70163_u) + 0.5;
        double rayZ = (double)z + Math.floor(entityLiving.field_70161_v) + 0.5 - (double)digWidth / 2.0;
        Vec3d rayOrigin = new Vec3d(rayX, rayY, rayZ);
        Vec3d rayOffset = new Vec3d(Math.floor(target.field_70165_t) + 0.5, Math.floor(target.field_70163_u) + 0.5, Math.floor(target.field_70161_v) + 0.5);
        rayOffset.func_72441_c((double)x - (double)digWidth / 2.0, (double)y, (double)z - (double)digWidth / 2.0);
        Vec3d norm = rayOffset.func_178788_d(rayOrigin).func_72432_b();
        if (Math.abs(norm.field_72450_a) == Math.abs(norm.field_72449_c) && norm.field_72450_a != 0.0) {
            norm = new Vec3d(norm.field_72450_a, norm.field_72448_b, 0.0).func_72432_b();
        }
        rayOffset = rayOrigin.func_178787_e(norm.func_186678_a(dist));
        BlockPos p1 = entityLiving.func_180425_c();
        if (p1.func_185332_f((p2 = target.func_180425_c()).func_177958_n(), p1.func_177956_o(), p2.func_177952_p()) < 4.0) {
            if ((double)(p2.func_177956_o() - p1.func_177956_o()) > 2.0) {
                rayOffset = rayOrigin.func_72441_c(0.0, dist, 0.0);
            } else if ((double)(p2.func_177956_o() - p1.func_177956_o()) < -2.0) {
                rayOffset = rayOrigin.func_72441_c(0.0, -dist, 0.0);
            }
        }
        RayTraceResult ray = entityLiving.field_70170_p.func_147447_a(rayOrigin, rayOffset, false, true, false);
        this.scanTick = (this.scanTick + 1) % passMax;
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ray.func_178782_a();
            IBlockState state = entityLiving.field_70170_p.func_180495_p(pos);
            if (this.canHarvest(entityLiving, pos) && ((List)CfgProps.DIG_BL.get((Entity)entityLiving)).contains(state.func_177230_c().getRegistryName().toString()) == ((Boolean)CfgProps.DIG_BL_INV.get((Entity)entityLiving)).booleanValue()) {
                return pos;
            }
        }
        return null;
    }

    private boolean canHarvest(EntityLiving entity, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        if (!state.func_185904_a().func_76220_a() || state.func_185887_b(entity.field_70170_p, pos) < 0.0f) {
            return false;
        }
        if (state.func_185904_a().func_76229_l() || !((Boolean)CfgProps.DIG_TOOLS.get((Entity)entity)).booleanValue()) {
            return true;
        }
        ItemStack held = entity.func_184586_b(EnumHand.MAIN_HAND);
        return !held.func_190926_b() && held.func_77973_b().canHarvestBlock(state, held);
    }
}

