/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.EnvironmentScope;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArithmeticUnary;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.casting.CastingRuleStaticMethod;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.LookupRequester;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassData;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassDataFetcher;
import youyihj.zenutils.impl.member.reflect.ReflectionClassData;
import youyihj.zenutils.impl.mixin.itf.IEnvironmentClassExtension;
import youyihj.zenutils.impl.util.ReflectUtils;
import youyihj.zenutils.impl.zenscript.nat.CraftTweakerBridge;
import youyihj.zenutils.impl.zenscript.nat.ExpressionNativeConstructorCall;
import youyihj.zenutils.impl.zenscript.nat.JavaNativeMemberSymbol;
import youyihj.zenutils.impl.zenscript.nat.NativeMethod;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNativeSuper;

public class ZenTypeJavaNative
extends ZenType {
    public static final ZenTypeJavaNative OBJECT = new ZenTypeJavaNative((ClassData)ReflectionClassData.of(Object.class), ZenTypeUtil.EMPTY_REGISTRY);
    private final ClassData clazz;
    private final Map<String, JavaNativeMemberSymbol> symbols = new HashMap<String, JavaNativeMemberSymbol>();
    private final List<ZenTypeJavaNative> superClasses;
    private static final IJavaMethod OBJECTS_EQUALS = JavaMethod.get((ITypeRegistry)ZenTypeUtil.EMPTY_REGISTRY, Objects.class, (String)"equals", (Class[])new Class[]{Object.class, Object.class});
    private static final Field METHOD_ENVIRONMENT_PARENT;
    private static final Field SCOPE_ENVIRONMENT_PARENT;

    public ZenTypeJavaNative(ClassData clazz, ITypeRegistry registry) {
        this(clazz, Stream.concat(ZenTypeJavaNative.optionalStream(clazz.superClass()), clazz.interfaces().stream()).map(it -> registry.getType(it.javaType())).filter(ZenTypeJavaNative.class::isInstance).map(ZenTypeJavaNative.class::cast).collect(Collectors.toList()));
    }

    protected ZenTypeJavaNative(ClassData clazz, List<ZenTypeJavaNative> superClasses) {
        this.clazz = clazz;
        this.superClasses = superClasses;
    }

    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        if (type == CompareType.EQ) {
            return new ExpressionCallStatic(position, environment, OBJECTS_EQUALS, new Expression[]{left, right});
        }
        if (type == CompareType.NE) {
            return new ExpressionArithmeticUnary(position, OperatorType.NOT, (Expression)new ExpressionCallStatic(position, environment, OBJECTS_EQUALS, new Expression[]{left, right}));
        }
        environment.error(position, "can not compare " + type + " between " + left.getType().getName() + " and " + right.getType().getName());
        return new ExpressionInvalid(position);
    }

    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        return this.getMember(position, environment, value, name, true);
    }

    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return this.getMember(position, environment, null, name, true);
    }

    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        Expression[] actualArguments = receiver == null ? arguments : (Expression[])ArrayUtils.add((Object[])arguments, (int)0, (Object)receiver);
        List<ExecutableData> constructors = this.clazz.constructors(this.getLookupRequester(environment));
        for (ExecutableData constructor : constructors) {
            if (!ZenTypeJavaNative.canAcceptConstructor(constructor, environment, actualArguments)) continue;
            return new ExpressionNativeConstructorCall(position, constructor, environment, actualArguments);
        }
        environment.error(position, "no such constructor matched");
        return new ExpressionInvalid(position);
    }

    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        CraftTweakerBridge.INSTANCE.getCaster(this.clazz).ifPresent(it -> rules.registerCastingRule(environment.getType(it.returnType().javaType()), (ICastingRule)new CastingRuleStaticMethod((IJavaMethod)new NativeMethod((ExecutableData)it, (ITypeRegistry)environment))));
    }

    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return null;
    }

    public Class<?> toJavaClass() {
        if (this.clazz instanceof ReflectionClassData) {
            return (Class)this.clazz.javaType();
        }
        if (this.clazz instanceof BytecodeClassData) {
            try {
                return ClassInfoClassLoader.INSTANCE.getClassInfo((BytecodeClassData)this.clazz);
            }
            catch (ClassNotFoundException e) {
                return Object.class;
            }
        }
        return Object.class;
    }

    public Type toASMType() {
        return Type.getType((String)this.clazz.descriptor());
    }

    public int getNumberType() {
        return 0;
    }

    public String getSignature() {
        return this.clazz.descriptor();
    }

    public boolean isPointer() {
        return true;
    }

    public String getAnyClassName(IEnvironmentGlobal environment) {
        return this.getName() + "Any";
    }

    public String getName() {
        return "native." + this.clazz.name();
    }

    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    public static boolean canAcceptConstructor(ExecutableData constructor, IEnvironmentGlobal environment, Expression[] arguments) {
        List<TypeData> parameters = constructor.parameters();
        if (arguments.length != parameters.size()) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].getType().canCastImplicit(environment.getType(parameters.get(i).javaType()), environment)) continue;
            return false;
        }
        return true;
    }

    protected JavaNativeMemberSymbol getSymbol(String name, IEnvironmentGlobal environment, boolean isStatic) {
        return this.symbols.computeIfAbsent(name, it -> JavaNativeMemberSymbol.of(environment, this.clazz, it, isStatic, this.getLookupRequester(environment)));
    }

    public IPartialExpression memberExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression value, String member) {
        IPartialExpression expression = super.memberExpansion(position, environment, value, member);
        if (expression == null) {
            for (ZenTypeJavaNative superClass : this.superClasses) {
                expression = superClass.memberExpansion(position, environment, value, member);
                if (expression == null) continue;
                return expression;
            }
        }
        return expression;
    }

    public ClassData getClassData() {
        return this.clazz;
    }

    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name, boolean logError) {
        Optional<ExecutableData> wrapperCaster;
        if (value != null && "wrapper".equals(name) && (wrapperCaster = CraftTweakerBridge.INSTANCE.getCaster(this.clazz)).isPresent()) {
            return new ExpressionCallStatic(position, environment, (IJavaMethod)new NativeMethod(wrapperCaster.get(), (ITypeRegistry)environment), new Expression[]{value.eval(environment)});
        }
        IPartialExpression member = this.getSymbol(name, environment, value == null).receiver(value).instance(position);
        if (member instanceof ExpressionInvalid) {
            IPartialExpression memberExpansion = null;
            if (value != null) {
                memberExpansion = this.memberExpansion(position, environment, value.eval(environment), name);
            }
            if (memberExpansion == null) {
                if (logError) {
                    environment.error(position, "no such member " + name + " in " + this.clazz.name());
                }
                return member;
            }
            return memberExpansion;
        }
        return member;
    }

    public ZenTypeJavaNativeSuper toSuper() {
        return new ZenTypeJavaNativeSuper(this.clazz, this.superClasses);
    }

    private static <T> Stream<T> optionalStream(T obj) {
        return obj == null ? Stream.empty() : Stream.of(obj);
    }

    LookupRequester getLookupRequester(IEnvironmentGlobal environment) {
        try {
            if (environment instanceof IEnvironmentClassExtension) {
                IEnvironmentClassExtension env = (IEnvironmentClassExtension)environment;
                if (env.getMixinTargets().contains(this.clazz.name())) {
                    return LookupRequester.SELF;
                }
                if (env.getSuperClasses().contains((Object)this)) {
                    return LookupRequester.SUBCLASS;
                }
                return LookupRequester.PUBLIC;
            }
            if (environment instanceof EnvironmentMethod) {
                return this.getLookupRequester((IEnvironmentGlobal)METHOD_ENVIRONMENT_PARENT.get(environment));
            }
            if (environment instanceof EnvironmentScope) {
                return this.getLookupRequester((IEnvironmentGlobal)SCOPE_ENVIRONMENT_PARENT.get(environment));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LookupRequester.PUBLIC;
    }

    static {
        try {
            METHOD_ENVIRONMENT_PARENT = ReflectUtils.removePrivate(EnvironmentMethod.class, "environment");
            SCOPE_ENVIRONMENT_PARENT = ReflectUtils.removePrivate(EnvironmentScope.class, "outer");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassInfoClassLoader
    extends ClassLoader {
        private static final ClassInfoClassLoader INSTANCE = new ClassInfoClassLoader();
        private final Map<String, Class<?>> classes = new ConcurrentHashMap();
        private WeakReference<BytecodeClassDataFetcher> classDataFetcherRef;

        private ClassInfoClassLoader() {
        }

        Class<?> getClassInfo(BytecodeClassData classData) throws ClassNotFoundException {
            String className = classData.name();
            if (this.classes.containsKey(className)) {
                return this.classes.get(className);
            }
            this.classDataFetcherRef = new WeakReference<BytecodeClassDataFetcher>(classData.getClassDataFetcher());
            Class<?> clazz = this.loadClass(classData.name());
            this.classes.put(className, clazz);
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                return c == null ? this.findClass(name) : c;
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            BytecodeClassDataFetcher classDataFetcher = (BytecodeClassDataFetcher)this.classDataFetcherRef.get();
            if (classDataFetcher == null) {
                return Launch.classLoader.loadClass(name);
            }
            ClassData classData = classDataFetcher.forName(name);
            if (classData instanceof ReflectionClassData) {
                return (Class)classData.javaType();
            }
            if (classData instanceof BytecodeClassData) {
                byte[] bytecode = ((BytecodeClassData)classData).getBytecode();
                return this.defineClass(name, bytecode, 0, bytecode.length);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

