/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.util.List;
import java.util.Optional;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.FieldData;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.util.Either;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.nat.DelegatedExpressionCallStatic;
import youyihj.zenutils.impl.zenscript.nat.ExpressionNativeGetter;
import youyihj.zenutils.impl.zenscript.nat.ExpressionNativeSetter;

public class PartialJavaNativeMember
implements IPartialExpression {
    private final ZenPosition position;
    private final String name;
    private final List<IJavaMethod> methods;
    private final IPartialExpression instanceValue;
    private final IEnvironmentGlobal environment;
    private final ClassData owner;
    private final Either<ExecutableData, FieldData> getter;
    private final Either<ExecutableData, FieldData> setter;
    private final boolean special;

    public PartialJavaNativeMember(ZenPosition position, String name, List<IJavaMethod> methods, IPartialExpression instanceValue, IEnvironmentGlobal environment, ClassData owner, Either<ExecutableData, FieldData> getter, Either<ExecutableData, FieldData> setter, boolean special) {
        this.position = position;
        this.name = name;
        this.methods = methods;
        this.instanceValue = instanceValue;
        this.environment = environment;
        this.owner = owner;
        this.getter = getter;
        this.setter = setter;
        this.special = special;
    }

    public Expression eval(IEnvironmentGlobal environment) {
        return new ExpressionNativeGetter(this.position, this.getter, this.instanceValue, environment, this.special);
    }

    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        return new ExpressionNativeSetter(position, this.setter, other, (IPartialExpression)(this.isStatic() ? null : this.instanceValue.eval(environment)), this.special);
    }

    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return this.getType().getMember(position, environment, (IPartialExpression)this, name);
    }

    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        IJavaMethod selected = JavaMethod.select((boolean)this.isStatic(), this.methods, (IEnvironmentGlobal)environment, (Expression[])values);
        if (selected != null) {
            if (this.isStatic()) {
                return new DelegatedExpressionCallStatic(position, (IEnvironmentGlobal)environment, selected, values);
            }
            return new ExpressionCallVirtual(position, (IEnvironmentGlobal)environment, selected, this.instanceValue.eval((IEnvironmentGlobal)environment), values);
        }
        return this.getNestedZenType((IEnvironmentGlobal)environment).map(it -> it.call(position, (IEnvironmentGlobal)environment, this.isStatic() ? null : this.instanceValue.eval((IEnvironmentGlobal)environment), values)).orElseGet(() -> {
            environment.error(position, "matched method " + this.name + ", but the argument types do not match");
            return new ExpressionInvalid(position);
        });
    }

    public ZenType[] predictCallTypes(int numArguments) {
        return JavaMethod.predict(this.methods, (int)numArguments);
    }

    public IZenSymbol toSymbol() {
        return position1 -> this;
    }

    public ZenType getType() {
        return this.eval(this.environment).getType();
    }

    public ZenType toType(IEnvironmentGlobal environment) {
        return this.getNestedZenType(environment).orElseGet(() -> {
            environment.error(this.position, "no such nested class");
            return ZenType.ANY;
        });
    }

    private Optional<ClassData> getNestedClass() {
        try {
            return Optional.of(InternalUtils.getClassDataFetcher().forName(this.owner.name() + "$" + this.name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<ZenType> getNestedZenType(IEnvironmentGlobal environment) {
        return this.getNestedClass().map(TypeData::javaType).map(arg_0 -> ((IEnvironmentGlobal)environment).getType(arg_0));
    }

    private boolean isStatic() {
        return this.instanceValue == null;
    }
}

