/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.util.List;
import java.util.stream.Collectors;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.zenscript.nat.ExpressionSuperConstructorCall;
import youyihj.zenutils.impl.zenscript.nat.NativeMethod;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNative;

public class PartialCallSuperConstructor
implements IPartialExpression {
    private final ZenPosition position;
    private final List<ExecutableData> constructorCandidates;
    private final List<IJavaMethod> constructorCandidateJavaMethods;

    public PartialCallSuperConstructor(ZenPosition position, List<ExecutableData> constructorCandidates, ITypeRegistry types) {
        this.position = position;
        this.constructorCandidates = constructorCandidates;
        this.constructorCandidateJavaMethods = constructorCandidates.stream().map(it -> new NativeMethod((ExecutableData)it, types)).collect(Collectors.toList());
    }

    public Expression eval(IEnvironmentGlobal environment) {
        return new ExpressionInvalid(this.position);
    }

    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        return new ExpressionInvalid(position);
    }

    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return new ExpressionInvalid(position);
    }

    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        for (ExecutableData constructorCandidate : this.constructorCandidates) {
            if (!ZenTypeJavaNative.canAcceptConstructor(constructorCandidate, (IEnvironmentGlobal)environment, values)) continue;
            return new ExpressionSuperConstructorCall(position, constructorCandidate, (IEnvironmentGlobal)environment, values);
        }
        environment.error(position, "no such constructor matched");
        return new ExpressionInvalid(position);
    }

    public ZenType[] predictCallTypes(int numArguments) {
        return JavaMethod.predict(this.constructorCandidateJavaMethods, (int)numArguments);
    }

    public IZenSymbol toSymbol() {
        return position1 -> this;
    }

    public ZenType getType() {
        return ZenType.VOID;
    }

    public ZenType toType(IEnvironmentGlobal environment) {
        environment.error(this.position, "can't convert to type");
        return ZenType.ANY;
    }
}

