/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Modifier;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.MethodOutput;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.TypeData;

public class NativeMethod
implements IJavaMethod {
    private final ExecutableData executable;
    private final ZenType returnType;
    private final ZenType[] parameterTypes;
    private final boolean special;

    public NativeMethod(ExecutableData executable, ITypeRegistry types) {
        this(executable, types, false);
    }

    public NativeMethod(ExecutableData executable, ITypeRegistry types, boolean special) {
        this.executable = executable;
        this.special = special;
        this.returnType = types.getType(executable.returnType().javaType());
        this.parameterTypes = (ZenType[])executable.parameters().stream().map(TypeData::javaType).map(arg_0 -> ((ITypeRegistry)types).getType(arg_0)).toArray(ZenType[]::new);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.executable.modifiers());
    }

    public boolean accepts(int numArguments) {
        return this.executable.parameterCount() == numArguments || this.executable.isVarArgs() && numArguments > this.executable.parameterCount();
    }

    public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
        return this.getPriority(environment, arguments) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
        ZenType argType;
        int result = 3;
        if (arguments.length > this.parameterTypes.length) {
            if (!this.isVarargs()) return -1;
            ZenType arrayType = this.parameterTypes[this.parameterTypes.length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            for (int i = this.parameterTypes.length - 1; i < arguments.length; ++i) {
                argType = arguments[i].getType();
                if (argType.equals((Object)baseType)) continue;
                if (!argType.canCastImplicit(baseType, environment)) return -1;
                result = 1;
            }
        } else if (arguments.length < this.parameterTypes.length) {
            return -1;
        }
        int checkUntil = arguments.length;
        if (arguments.length == this.parameterTypes.length && this.isVarargs()) {
            ZenType arrayType = this.parameterTypes[this.parameterTypes.length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            argType = arguments[arguments.length - 1].getType();
            if (!argType.equals((Object)arrayType) && !argType.equals((Object)baseType)) {
                if (argType.canCastImplicit(arrayType, environment)) {
                    result = 1;
                } else {
                    if (!argType.canCastImplicit(baseType, environment)) return -1;
                    result = 1;
                }
            }
            checkUntil = arguments.length - 1;
        }
        for (int i = 0; i < checkUntil; ++i) {
            ZenType paramType;
            ZenType argType2 = arguments[i].getType();
            if (argType2.equals((Object)(paramType = this.parameterTypes[i]))) continue;
            if (!argType2.canCastImplicit(paramType, environment)) return -1;
            result = 1;
        }
        return result;
    }

    public void invokeVirtual(MethodOutput output) {
        if (this.isStatic()) {
            throw new UnsupportedOperationException("Method is static");
        }
        if (this.executable.declaringClass().isInterface()) {
            output.invokeInterface(this.executable.declaringClass().internalName(), this.executable.name(), this.executable.descriptor());
        } else if (this.special) {
            output.invokeSpecial(this.executable.declaringClass().internalName(), this.executable.name(), this.executable.descriptor());
        } else {
            output.invokeVirtual(this.executable.declaringClass().internalName(), this.executable.name(), this.executable.descriptor());
        }
    }

    public void invokeStatic(MethodOutput output) {
        if (!this.isStatic()) {
            throw new UnsupportedOperationException("Method is not static");
        }
        output.getVisitor().visitMethodInsn(184, this.executable.declaringClass().internalName(), this.executable.name(), this.executable.descriptor(), this.executable.declaringClass().isInterface());
    }

    public ZenType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ZenType getReturnType() {
        return this.returnType;
    }

    public boolean isVarargs() {
        return this.executable.isVarArgs();
    }

    public String getErrorDescription() {
        return this.executable.descriptor();
    }
}

