/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import stanhebben.zenscript.annotations.ZenClass;
import youyihj.zenutils.api.zenscript.INativeClassExclude;
import youyihj.zenutils.impl.member.ClassData;

public class NativeClassValidate {
    public static final List<INativeClassExclude> EXCLUDES = new ArrayList<INativeClassExclude>();
    private static final List<String> JAVA_LANG_WHITELIST = ImmutableList.of((Object)Integer.class.getName(), (Object)Long.class.getName(), (Object)Short.class.getName(), (Object)Double.class.getName(), (Object)Float.class.getName(), (Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Object.class.getName(), (Object)Enum.class.getName(), (Object)Comparable.class.getName(), (Object)Iterable.class.getName(), (Object)Math.class.getName(), (Object[])new String[]{StrictMath.class.getName(), StringBuilder.class.getName()});

    public static boolean isValid(ClassData clazz, boolean allowZenClasses) {
        return JAVA_LANG_WHITELIST.contains(clazz.name()) || (allowZenClasses || !clazz.isAnnotationPresent(ZenClass.class)) && EXCLUDES.stream().noneMatch(it -> it.shouldExclude(clazz));
    }

    public static boolean isValid(ClassData clazz) {
        return NativeClassValidate.isValid(clazz, false);
    }

    static {
        Lists.newArrayList((Object[])new String[]{"java.io", "java.nio", "java.awt", "java.applet", "java.rmi", "java.net", "java.lang", "java.security", "java.util.zip", "java.util.concurrent", "java.util.logging", "scala", "kotlin", "crafttweaker", "stanhebben.zenscript", "com.teamacronymcoders.contenttweaker", "org.apache.commons.io", "org.apache.http", "org.apache.logging", "io.netty", "org.spongepowered.asm", "org.objectweb.asm", "sun.", "youyihj.zenutils.impl", "jdk", "javax", "groovy", "com.cleanroommc.groovyscript"}).forEach(INativeClassExclude::filterPrefix);
        INativeClassExclude.filterClass(Scanner.class);
    }
}

