/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.FieldData;
import youyihj.zenutils.impl.member.LookupRequester;

public enum MCPReobfuscation {
    INSTANCE;

    private final CompletableFuture<Pair<Multimap<String, String>, Multimap<String, String>>> mappers = CompletableFuture.supplyAsync(this::init);

    public FieldData reobfField(ClassData owner, String name, LookupRequester requester) {
        Collection possibleNames = ((Multimap)this.mappers.join().getRight()).get((Object)name);
        List<FieldData> fields = owner.fields(requester);
        for (String possibleSrgName : possibleNames) {
            try {
                return this.findField(fields, possibleSrgName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        try {
            return this.findField(fields, name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public Stream<ExecutableData> reobfMethodOverloads(ClassData owner, String name, LookupRequester requester) {
        ImmutableList possibleNames = ImmutableList.builder().addAll((Iterable)((Multimap)this.mappers.join().getLeft()).get((Object)name)).add((Object)name).build();
        return owner.methods(requester).stream().filter(arg_0 -> MCPReobfuscation.lambda$reobfMethodOverloads$0((Collection)possibleNames, arg_0));
    }

    public ExecutableData reobfMethod(ClassData owner, String name, LookupRequester requester) {
        return this.reobfMethodOverloads(owner, name, requester).findFirst().orElse(null);
    }

    private FieldData findField(List<FieldData> fields, String name) throws NoSuchFieldException {
        for (FieldData field : fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        throw new NoSuchFieldException(name);
    }

    private Pair<Multimap<String, String>, Multimap<String, String>> init() {
        HashMultimap methodMap = HashMultimap.create();
        HashMultimap fieldMap = HashMultimap.create();
        Path localMapping = Paths.get("config", "mcp_stable-39-1.12.zip");
        String remoteMapping = "https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_stable/39-1.12/mcp_stable-39-1.12.zip";
        if (!Files.exists(localMapping, new LinkOption[0])) {
            try {
                URL url = new URL(remoteMapping);
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(30000);
                urlConnection.setReadTimeout(30000);
                Files.copy(url.openStream(), localMapping, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to download mcp mapping, try download it manually to `config/mcp_stable-39-1.12.zip`, uri: " + remoteMapping, e);
            }
        }
        try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:" + localMapping.toUri().toASCIIString()), Collections.emptyMap());){
            try (Stream<String> methodStream = Files.lines(zipFs.getPath("methods.csv", new String[0]));){
                methodStream.skip(1L).map(it -> it.split(",")).forEach(arg_0 -> MCPReobfuscation.lambda$init$2((Multimap)methodMap, arg_0));
            }
            methodStream = Files.lines(zipFs.getPath("fields.csv", new String[0]));
            var8_12 = null;
            try {
                methodStream.skip(1L).map(it -> it.split(",")).forEach(arg_0 -> MCPReobfuscation.lambda$init$4((Multimap)fieldMap, arg_0));
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (methodStream != null) {
                    if (var8_12 != null) {
                        try {
                            methodStream.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        methodStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read mcp mapping", e);
        }
        return Pair.of((Object)methodMap, (Object)fieldMap);
    }

    private static /* synthetic */ void lambda$init$4(Multimap fieldMap, String[] it) {
        fieldMap.put((Object)it[1], (Object)it[0]);
    }

    private static /* synthetic */ void lambda$init$2(Multimap methodMap, String[] it) {
        methodMap.put((Object)it[1], (Object)it[0]);
    }

    private static /* synthetic */ boolean lambda$reobfMethodOverloads$0(Collection possibleNames, ExecutableData it) {
        return possibleNames.contains(it.name());
    }
}

