/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.expression.partial.PartialType;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.FieldData;
import youyihj.zenutils.impl.member.LookupRequester;
import youyihj.zenutils.impl.util.Either;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.nat.MCPReobfuscation;
import youyihj.zenutils.impl.zenscript.nat.NativeMethod;
import youyihj.zenutils.impl.zenscript.nat.PartialJavaNativeMember;

public class JavaNativeMemberSymbol
implements IZenSymbol {
    private final String name;
    private final ClassData owner;
    private final IEnvironmentGlobal environment;
    private final boolean isStatic;
    private final LookupRequester lookupRequester;
    private final List<IJavaMethod> methods;
    private final Either<ExecutableData, FieldData> getter;
    private final Either<ExecutableData, FieldData> setter;
    private final IPartialExpression receiver;
    private final boolean special;

    private JavaNativeMemberSymbol(IEnvironmentGlobal environment, ClassData owner, String name, boolean isStatic, LookupRequester lookupRequester, IPartialExpression receiver, boolean special) {
        this.name = name;
        this.environment = environment;
        this.owner = owner;
        this.isStatic = isStatic;
        this.receiver = receiver;
        this.lookupRequester = lookupRequester;
        this.special = special;
        this.methods = MCPReobfuscation.INSTANCE.reobfMethodOverloads(owner, name, lookupRequester).filter(it -> this.validateModifier(it.modifiers())).map(it -> new NativeMethod((ExecutableData)it, (ITypeRegistry)environment, special)).collect(Collectors.toList());
        this.getter = Either.left(MCPReobfuscation.INSTANCE.reobfMethod(owner, "get" + StringUtils.capitalize((String)name), lookupRequester)).validateLeft(this::validateGetter).orElseLeft(() -> MCPReobfuscation.INSTANCE.reobfMethod(owner, "is" + StringUtils.capitalize((String)name), lookupRequester)).validateLeft(this::validateGetter).orElseRight(() -> MCPReobfuscation.INSTANCE.reobfField(owner, name, lookupRequester)).validateRight(this::validateFieldGet);
        this.setter = Either.left(MCPReobfuscation.INSTANCE.reobfMethod(owner, "set" + StringUtils.capitalize((String)name), lookupRequester)).validateLeft(this::validateSetter).orElseRight(() -> MCPReobfuscation.INSTANCE.reobfField(owner, name, lookupRequester)).validateRight(this::validateFieldSet);
    }

    public static JavaNativeMemberSymbol of(IEnvironmentGlobal environment, ClassData owner, String name, boolean isStatic, LookupRequester lookupRequester) {
        return new JavaNativeMemberSymbol(environment, owner, name, isStatic, lookupRequester, null, false);
    }

    public JavaNativeMemberSymbol receiver(IPartialExpression instanceValue) {
        if (!this.isStatic) {
            return new JavaNativeMemberSymbol(this.environment, this.owner, this.name, false, this.lookupRequester, instanceValue, this.special);
        }
        if (instanceValue == null) {
            return this;
        }
        throw new IllegalStateException("set instance to static symbol");
    }

    public JavaNativeMemberSymbol special() {
        return new JavaNativeMemberSymbol(this.environment, this.owner, this.name, this.isStatic, this.lookupRequester, this.receiver, true);
    }

    public IPartialExpression instance(ZenPosition position) {
        if (!this.isStatic && this.receiver == null) {
            throw new IllegalStateException("missing instance value of virtual symbol");
        }
        if (this.getter.isEmpty() && this.setter.isEmpty() && this.methods.isEmpty()) {
            if (this.isStatic) {
                try {
                    return new PartialType(position, this.environment.getType(InternalUtils.getClassDataFetcher().forName(this.owner.name() + "$" + this.name).javaType()));
                }
                catch (ClassNotFoundException e) {
                    this.environment.error(position, "no such static member or nested class: " + this.owner.name() + "." + this.name);
                }
            }
        } else {
            return new PartialJavaNativeMember(position, this.name, this.methods, this.receiver, this.environment, this.owner, this.getter, this.setter, this.special);
        }
        return new ExpressionInvalid(position);
    }

    private boolean validateGetter(ExecutableData method) {
        return method.parameterCount() == 0 && this.validateModifier(method.modifiers());
    }

    private boolean validateSetter(ExecutableData method) {
        return method.parameterCount() == 1 && this.validateModifier(method.modifiers());
    }

    private boolean validateFieldGet(FieldData field) {
        return this.validateModifier(field.modifiers());
    }

    private boolean validateFieldSet(FieldData field) {
        return this.validateModifier(field.modifiers()) && !Modifier.isFinal(field.modifiers());
    }

    private boolean validateModifier(int modifier) {
        return Modifier.isStatic(modifier) == this.isStatic;
    }
}

