/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.LookupRequester;
import youyihj.zenutils.impl.util.InternalUtils;

public enum CraftTweakerBridge {
    INSTANCE;

    private final Map<String, ExecutableData> casters = new HashMap<String, ExecutableData>();
    private LoaderState loaderState;

    private CraftTweakerBridge() {
        this.refresh();
    }

    private void refresh() {
        this.loaderState = Loader.instance().getLoaderState();
        this.casters.clear();
        try {
            ClassData craftTweakerMC = InternalUtils.getClassDataFetcher().forName("crafttweaker.api.minecraft.CraftTweakerMC");
            for (ExecutableData method : craftTweakerMC.methods(LookupRequester.PUBLIC)) {
                if (!method.name().startsWith("get") || method.parameterCount() != 1) continue;
                ClassData toConvert = method.parameters().get(0).asClassData();
                String toConvertClassName = toConvert.name();
                if (toConvertClassName.startsWith("crafttweaker.")) {
                    this.casters.put(toConvert.name(), method);
                    continue;
                }
                if (!toConvertClassName.startsWith("net.minecraft")) continue;
                this.casters.put(toConvert.name(), method);
            }
            craftTweakerMC.methods("getItemStack", LookupRequester.PUBLIC).forEach(it -> {
                String paraName = it.parameters().get(0).asClassData().name();
                if (paraName.endsWith("ItemStack")) {
                    this.casters.put(paraName, (ExecutableData)it);
                }
            });
            this.casters.put("net.minecraft.item.ItemStack", craftTweakerMC.methods("getIItemStack", LookupRequester.PUBLIC).get(0));
            this.casters.put("crafttweaker.api.item.IIngredient", craftTweakerMC.methods("getIngredient", LookupRequester.PUBLIC).get(0));
            this.casters.put("net.minecraft.item.crafting.Ingredient", craftTweakerMC.methods("getIIngredient", LookupRequester.PUBLIC).get(0));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ExecutableData> getCaster(ClassData clazz) {
        if (this.loaderState != Loader.instance().getLoaderState()) {
            this.refresh();
        }
        return Optional.ofNullable(this.casters.get(clazz.name()));
    }
}

