/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.mixin;

import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.zenscript.mixin.ZenTypeMixinCallbackInfo;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNative;

public class ZenTypeMixinCallbackInfoReturnable
extends ZenTypeMixinCallbackInfo {
    public static final ZenTypeMixinCallbackInfoReturnable INSTANCE = new ZenTypeMixinCallbackInfoReturnable();

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        switch (name) {
            case "setReturnValue": {
                return new SetReturnValue(position, value);
            }
            case "getReturnValue": {
                return new GetReturnValue(name, ZenTypeJavaNative.OBJECT, position, value);
            }
            case "getReturnValueB": {
                return new GetReturnValue(name, (ZenType)BYTE, position, value);
            }
            case "getReturnValueD": {
                return new GetReturnValue(name, (ZenType)DOUBLE, position, value);
            }
            case "getReturnValueF": {
                return new GetReturnValue(name, (ZenType)FLOAT, position, value);
            }
            case "getReturnValueI": {
                return new GetReturnValue(name, (ZenType)INT, position, value);
            }
            case "getReturnValueJ": {
                return new GetReturnValue(name, (ZenType)LONG, position, value);
            }
            case "getReturnValueS": {
                return new GetReturnValue(name, (ZenType)SHORT, position, value);
            }
            case "getReturnValueZ": {
                return new GetReturnValue(name, (ZenType)BOOL, position, value);
            }
        }
        return super.getMember(position, environment, value, name);
    }

    @Override
    public Class<?> toJavaClass() {
        return CallbackInfoReturnable.class;
    }

    private class GetReturnValue
    implements IPartialExpression {
        private final String methodName;
        private final ZenType returnType;
        private final ZenPosition position;
        private final IPartialExpression value;

        public GetReturnValue(String methodName, ZenType returnType, ZenPosition position, IPartialExpression value) {
            this.methodName = methodName;
            this.returnType = returnType;
            this.position = position;
            this.value = value;
        }

        public Expression eval(IEnvironmentGlobal environment) {
            environment.error(this.position, "not supported");
            return new ExpressionInvalid(this.position);
        }

        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            environment.error(position, "not supported");
            return new ExpressionInvalid(position);
        }

        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            environment.error(position, "not supported");
            return new ExpressionInvalid(position);
        }

        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            if (values.length != 0) {
                environment.error(position, "getReturnValue method accepts 0 argument");
                return new ExpressionInvalid(position);
            }
            IJavaMethod method = JavaMethod.get((ITypeRegistry)environment, ZenTypeMixinCallbackInfoReturnable.this.toJavaClass(), (String)this.methodName, (Class[])new Class[0]);
            return new ExpressionCallVirtual(position, (IEnvironmentGlobal)environment, method, this.value.eval((IEnvironmentGlobal)environment), new Expression[0]);
        }

        public ZenType[] predictCallTypes(int numArguments) {
            return new ZenType[0];
        }

        public IZenSymbol toSymbol() {
            return null;
        }

        public ZenType getType() {
            return this.returnType;
        }

        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not supported");
            return ZenType.ANY;
        }
    }

    private class SetReturnValue
    implements IPartialExpression {
        private final ZenPosition position;
        private final IPartialExpression value;

        public SetReturnValue(ZenPosition position, IPartialExpression value) {
            this.position = position;
            this.value = value;
        }

        public Expression eval(IEnvironmentGlobal environment) {
            environment.error(this.position, "not supported");
            return new ExpressionInvalid(this.position);
        }

        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            environment.error(position, "not supported");
            return new ExpressionInvalid(position);
        }

        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            environment.error(position, "not supported");
            return new ExpressionInvalid(position);
        }

        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            if (values.length != 1) {
                environment.error(position, "setReturnValue method accepts 1 argument");
            }
            Expression arg = values[0];
            ZenType type = arg.getType();
            IJavaMethod method = JavaMethod.get((ITypeRegistry)environment, ZenTypeMixinCallbackInfoReturnable.this.toJavaClass(), (String)"setReturnValue", (Class[])new Class[]{Object.class});
            if (type == ZenType.INT) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, INT_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.LONG) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, LONG_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.FLOAT) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, FLOAT_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.DOUBLE) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, DOUBLE_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.BYTE) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, BYTE_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.SHORT) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, SHORT_VALUEOF, new Expression[]{arg});
            } else if (type == ZenType.BOOL) {
                arg = new ExpressionCallStatic(position, (IEnvironmentGlobal)environment, BOOL_VALUEOF, new Expression[]{arg});
            }
            return new ExpressionCallVirtual(position, (IEnvironmentGlobal)environment, method, this.value.eval((IEnvironmentGlobal)environment), new Expression[]{arg});
        }

        public ZenType[] predictCallTypes(int numArguments) {
            return new ZenType[1];
        }

        public IZenSymbol toSymbol() {
            return null;
        }

        public ZenType getType() {
            return ZenType.VOID;
        }

        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not supported");
            return ZenType.ANY;
        }
    }
}

