/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.mixin;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.ITweaker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.transformer.MixinProcessor;
import org.spongepowered.asm.mixin.transformer.MixinTransformer;
import org.spongepowered.asm.mixin.transformer.Proxy;
import stanhebben.zenscript.ZenModule;
import youyihj.zenutils.Reference;
import youyihj.zenutils.impl.mixin.custom.CustomMixinPlugin;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.runtime.ZenUtilsTweaker;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.MixinPreprocessor;

public class ZenMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"ZenMixin");
    private static final Multiset<String> mixinNameUsedCounter = HashMultiset.create();

    public static void load() throws Exception {
        ITweaker tweaker = CraftTweakerAPI.tweaker;
        Preconditions.checkState((boolean)(tweaker instanceof ZenUtilsTweaker), (Object)"CraftTweaker ITweaker is not redirected. A mixin config is failed. please report to the mod author!");
        PreprocessorManager preprocessorManager = tweaker.getPreprocessorManager();
        preprocessorManager.registerPreprocessorAction("mixin", MixinPreprocessor::new);
        Class classLoaderClass = Reference.IS_CLEANROOM ? Class.forName("top.outlands.foundation.boot.ActualClassLoader") : LaunchClassLoader.class;
        Field lclBytecodesField = classLoaderClass.getDeclaredField("resourceCache");
        lclBytecodesField.setAccessible(true);
        Map resourceCache = (Map)lclBytecodesField.get(Launch.classLoader);
        tweaker.setNetworkSide(FMLCommonHandler.instance().getSide().isClient() ? NetworkSide.SIDE_CLIENT : NetworkSide.SIDE_SERVER);
        tweaker.loadScript(false, "mixin");
        ZenModule.classes.forEach((name, bytecode) -> {
            if (name.startsWith("youyihj/zenutils/impl/mixin/custom/")) {
                resourceCache.put(name.replace('/', '.'), bytecode);
                String classSimpleName = name.substring("youyihj/zenutils/impl/mixin/custom/".length());
                CustomMixinPlugin.addMixinClass(classSimpleName);
                LOGGER.info("Loaded mixin class {}", (Object)classSimpleName);
                CraftTweakerAPI.logInfo((String)("Loaded mixin class: " + classSimpleName));
            } else {
                LOGGER.info("Injecting non-mixin class: {} to mc LaunchClassLoader", name);
                CraftTweakerAPI.logInfo((String)("Adding non-mixin class: " + name + " to mc LaunchClassLoader"));
                resourceCache.put(name, bytecode);
            }
        });
        Mixins.addConfiguration((String)"mixins.zenutils.custom.json");
        Field processorField = MixinTransformer.class.getDeclaredField("processor");
        processorField.setAccessible(true);
        MixinProcessor processor = (MixinProcessor)processorField.get(Proxy.transformer);
        Method selectMethod = processor.getClass().getDeclaredMethod("select", MixinEnvironment.class);
        selectMethod.setAccessible(true);
        selectMethod.invoke((Object)processor, Reference.IS_CLEANROOM ? MixinEnvironment.getDefaultEnvironment() : MixinEnvironment.getCurrentEnvironment());
    }

    public static String handleMixinClassName(String className) {
        String mixinClassName = "youyihj/zenutils/impl/mixin/custom/" + className;
        if (InternalUtils.getScriptStatus() != ScriptStatus.SYNTAX) {
            int usedCountBefore = mixinNameUsedCounter.count((Object)className);
            mixinNameUsedCounter.add((Object)className);
            if (usedCountBefore != 0) {
                mixinClassName = mixinClassName + usedCountBefore;
            }
        }
        return mixinClassName;
    }
}

