/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.preprocessor.IPreprocessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.SoftOverride;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Desc;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.Surrogate;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.MixinPreprocessor;

public class MixinAnnotationTranslator {
    private static final Map<String, Class<?>> SUPPORTED_ANNOTATIONS = new HashMap();

    private static void register(Class<?> ... annotations) {
        for (Class<?> annotation : annotations) {
            SUPPORTED_ANNOTATIONS.put(annotation.getSimpleName(), annotation);
        }
    }

    public static List<MixinPreprocessor> findAnnotation(ZenPosition position) {
        MixinPreprocessor mixinPreprocessor;
        List filePreprocessors = (List)CraftTweakerAPI.tweaker.getPreprocessorManager().preprocessorActionsPerFile.get(position.getFileName());
        ArrayList<MixinPreprocessor> found = new ArrayList<MixinPreprocessor>();
        if (filePreprocessors == null) {
            return found;
        }
        Int2ObjectOpenHashMap mixinPreprocessors = new Int2ObjectOpenHashMap();
        for (IPreprocessor preprocessor : filePreprocessors) {
            if (!(preprocessor instanceof MixinPreprocessor)) continue;
            MixinPreprocessor mixinPreprocessor2 = (MixinPreprocessor)preprocessor;
            mixinPreprocessors.put(mixinPreprocessor2.getLineRange().getTo(), (Object)mixinPreprocessor2);
        }
        int line = position.getLine() - 2;
        while ((mixinPreprocessor = (MixinPreprocessor)mixinPreprocessors.get(line)) != null) {
            found.add(0, mixinPreprocessor);
            line -= mixinPreprocessor.getPreprocessorLines().size();
        }
        return found;
    }

    public static void translate(String type, JsonElement json, BiFunction<String, Boolean, AnnotationVisitor> visitorPrimer, Function<String, ParseException> exceptionFactory) throws ParseException {
        Class<?> annotationType = SUPPORTED_ANNOTATIONS.get(type);
        if (annotationType == null) {
            throw exceptionFactory.apply("unsupported mixin annotation: " + type);
        }
        AnnotationVisitor visitor = visitorPrimer.apply(Type.getDescriptor(annotationType), MixinAnnotationTranslator.isVisibleOnRuntime(annotationType));
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            Class<?> expectedType;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            try {
                expectedType = annotationType.getMethod(key, new Class[0]).getReturnType();
            }
            catch (NoSuchMethodException e) {
                throw exceptionFactory.apply(key + " does not exist in " + annotationType);
            }
            MixinAnnotationTranslator.writeContentToAnnotation(visitor, expectedType, key, value, exceptionFactory);
        }
        MixinAnnotationTranslator.processAnnotation(annotationType, visitor, json.getAsJsonObject(), exceptionFactory);
        visitor.visitEnd();
    }

    public static List<String> getMixinTargets(JsonObject json) {
        ArrayList<String> targets = new ArrayList<String>();
        if (json.has("targets")) {
            JsonElement targetsJson = json.get("targets");
            if (targetsJson.isJsonArray()) {
                for (JsonElement target : targetsJson.getAsJsonArray()) {
                    targets.add(target.getAsString());
                }
            } else {
                targets.add(targetsJson.getAsString());
            }
        }
        if (json.has("value")) {
            JsonElement valueJson = json.get("value");
            if (valueJson.isJsonArray()) {
                for (JsonElement target : valueJson.getAsJsonArray()) {
                    targets.add(target.getAsString().replace('/', '.'));
                }
            } else {
                targets.add(valueJson.getAsString().replace('/', '.'));
            }
        }
        return targets;
    }

    private static void writeContentToAnnotation(AnnotationVisitor visitor, Class<?> expectedType, String key, JsonElement value, Function<String, ParseException> exceptionFactory) {
        if (expectedType == Integer.TYPE) {
            visitor.visit(key, (Object)value.getAsInt());
        } else if (expectedType == Long.TYPE) {
            visitor.visit(key, (Object)value.getAsLong());
        } else if (expectedType == Float.TYPE) {
            visitor.visit(key, (Object)Float.valueOf(value.getAsFloat()));
        } else if (expectedType == Double.TYPE) {
            visitor.visit(key, (Object)value.getAsDouble());
        } else if (expectedType == Boolean.TYPE) {
            visitor.visit(key, (Object)value.getAsBoolean());
        } else if (expectedType == String.class) {
            visitor.visit(key, (Object)value.getAsString());
        } else if (expectedType == Byte.TYPE) {
            visitor.visit(key, (Object)value.getAsByte());
        } else if (expectedType == Character.TYPE) {
            visitor.visit(key, (Object)Character.valueOf(value.getAsCharacter()));
        } else if (expectedType == Short.TYPE) {
            visitor.visit(key, (Object)value.getAsShort());
        } else if (expectedType == Class.class) {
            visitor.visit(key, (Object)Type.getObjectType((String)value.getAsString()));
        } else if (expectedType.isEnum()) {
            visitor.visitEnum(key, Type.getDescriptor(expectedType), value.getAsString());
        } else if (expectedType.isArray()) {
            AnnotationVisitor arrayVisitor = visitor.visitArray(key);
            if (value.isJsonArray()) {
                for (JsonElement content : value.getAsJsonArray()) {
                    MixinAnnotationTranslator.writeContentToAnnotation(arrayVisitor, expectedType.getComponentType(), key, content, exceptionFactory);
                }
                arrayVisitor.visitEnd();
            } else {
                MixinAnnotationTranslator.writeContentToAnnotation(arrayVisitor, expectedType.getComponentType(), key, value, exceptionFactory);
                arrayVisitor.visitEnd();
            }
        } else if (expectedType == At.class) {
            MixinAnnotationTranslator.translate("At", value, (type, visible) -> visitor.visitAnnotation(key, type), exceptionFactory);
        } else if (expectedType == Slice.class) {
            MixinAnnotationTranslator.translate("Slice", value, (type, visible) -> visitor.visitAnnotation(key, type), exceptionFactory);
        } else if (expectedType == Constant.class) {
            MixinAnnotationTranslator.translate("Constant", value, (type, visible) -> visitor.visitAnnotation(key, type), exceptionFactory);
        }
    }

    private static boolean isVisibleOnRuntime(Class<?> annotationType) {
        return annotationType.getAnnotation(Retention.class).value() == RetentionPolicy.RUNTIME;
    }

    private static void processAnnotation(Class<?> annotationType, AnnotationVisitor visitor, JsonObject json, Function<String, ParseException> exceptionFactory) throws ParseException {
        if (InternalUtils.hasMethod(annotationType, "remap", new Class[0])) {
            visitor.visit("remap", (Object)false);
            if (json.has("remap")) {
                throw exceptionFactory.apply("remap always is false");
            }
        }
    }

    static {
        MixinAnnotationTranslator.register(Mixin.class, Final.class, Mutable.class, Overwrite.class, Pseudo.class, Shadow.class, SoftOverride.class, Unique.class, Inject.class, Group.class, ModifyArg.class, ModifyArgs.class, ModifyConstant.class, ModifyVariable.class, Redirect.class, Surrogate.class, Desc.class, At.class, Slice.class, Constant.class);
    }
}

