/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript;

import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.parser.CompiledDFA;
import stanhebben.zenscript.parser.NFA;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.parser.TokenStream;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.mixin.crafttweaker.TokenStreamAccessor;
import youyihj.zenutils.impl.zenscript.LiteralTokener;

public class TemplateStringTokener
extends TokenStream {
    public static final int T_FALLBACK = Integer.MAX_VALUE;
    public static final String T_FALLBACK_REGEX = ".";
    private static CompiledDFA DFA;
    private ZenPosition startPosition;
    private boolean constructing;

    public static void setupDFAFromZenTokener(String[] zenRegexps, int[] zenFinals) {
        String[] regexp = new String[zenRegexps.length - 3];
        int[] finals = new int[zenFinals.length - 3];
        System.arraycopy(zenRegexps, 4, regexp, 0, zenRegexps.length - 4);
        System.arraycopy(zenFinals, 4, finals, 0, zenFinals.length - 4);
        regexp[regexp.length - 1] = T_FALLBACK_REGEX;
        finals[finals.length - 1] = Integer.MAX_VALUE;
        DFA = new NFA(regexp, finals).toDFA().optimize().compile();
    }

    public TemplateStringTokener(String data, ZenPosition startPosition) throws IOException {
        super(data, DFA);
        this.setFile(startPosition.getFile());
    }

    public static TemplateStringTokener create(String data, ZenPosition startPosition) {
        try {
            return new TemplateStringTokener(data, startPosition);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LiteralTokener toLiteral(IZenCompileEnvironment environment) {
        return LiteralTokener.create(new PeekingIterator<Token>(){

            public Token peek() {
                if (TemplateStringTokener.this.hasNext()) {
                    Token token = TemplateStringTokener.this.peek();
                    while (TemplateStringTokener.this.hasNext() && this.isInvalid(token)) {
                        TemplateStringTokener.this.next();
                        token = TemplateStringTokener.this.peek();
                    }
                    return this.isInvalid(token) ? null : token;
                }
                return null;
            }

            public Token next() {
                while (TemplateStringTokener.this.hasNext()) {
                    Token token = TemplateStringTokener.this.next();
                    if (this.isInvalid(token)) continue;
                    return token;
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.peek() != null;
            }

            private boolean isInvalid(Token token) {
                return token.getType() < 0 || token.getType() == Integer.MAX_VALUE;
            }
        }, environment, this.startPosition.getFile());
    }

    protected Token process(Token token) {
        if (this.constructing) {
            TokenStreamAccessor accessor = (TokenStreamAccessor)((Object)this);
            accessor.setLine(this.startPosition.getLine());
            accessor.setLineOffset(this.startPosition.getLineOffset());
            this.constructing = false;
        }
        if (token == null) {
            return new Token("", -1, this.startPosition);
        }
        ZenPosition position = token.getPosition();
        int offsetLine = position.getLine() + this.startPosition.getLine() - 1;
        int offsetLineOffset = position.getLine() == 1 ? position.getLineOffset() : position.getLineOffset() + this.startPosition.getLineOffset() - 1;
        ZenPosition offsetPosition = new ZenPosition(this.startPosition.getFile(), offsetLine, offsetLineOffset, position.getFileName());
        return new Token(token.getValue(), token.getType(), offsetPosition);
    }
}

