/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.parser.expression.ParsedExpression;
import stanhebben.zenscript.parser.expression.ParsedExpressionValue;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.zenscript.ExpressionTemplateString;
import youyihj.zenutils.impl.zenscript.LiteralTokener;
import youyihj.zenutils.impl.zenscript.TemplateStringTokener;

public class TemplateString {
    public static final int T_TEMPLATE_STRING = 196;
    public static final String T_TEMPLATE_STRING_REGEX = "`([^`\\\\]|\\\\([\\\\`$bfnrt]|u[0-9a-fA-F]{4}))*`";
    public static final int T_ESCAPE_CHAR = 197;
    public static final String T_ESCAPE_CHAR_REGEX = "\\\\([\\\\`$ntbfr]|u[0-9a-fA-F]{4})";

    public static ParsedExpression getExpression(ZenTokener tokener, ZenPosition position, IEnvironmentGlobal environment) {
        List<ParsedExpression> parsed = TemplateString.parse(tokener, position, environment);
        return new ParsedExpressionValue(position, (IPartialExpression)new ExpressionTemplateString(position, parsed));
    }

    public static Expression getExpression(List<Token> tokens, ZenPosition position, IEnvironmentGlobal environment) {
        return new ExpressionTemplateString(position, TemplateString.parse(tokens, position, environment));
    }

    private static void handleEscapeChar(Token token, StringBuilder sb) {
        char escapeChar = token.getValue().charAt(1);
        switch (escapeChar) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 'b': {
                sb.append('\b');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            case '$': {
                sb.append('$');
                break;
            }
            case '`': {
                sb.append('`');
                break;
            }
            case 'u': {
                sb.append(Character.toChars(Integer.parseInt(token.getValue().substring(2), 16)));
            }
        }
    }

    private static List<ParsedExpression> parse(ZenTokener tokener, ZenPosition position, IEnvironmentGlobal environment) throws ParseException {
        String content = tokener.next().getValue();
        content = content.substring(1, content.length() - 1);
        ArrayList<ParsedExpression> expressions = new ArrayList<ParsedExpression>();
        StringBuilder literals = new StringBuilder();
        TemplateStringTokener templateStringTokener = TemplateStringTokener.create(content, position);
        block4: while (templateStringTokener.hasNext()) {
            Token token = templateStringTokener.next();
            switch (token.getType()) {
                case 197: {
                    TemplateString.handleEscapeChar(token, literals);
                    continue block4;
                }
                case 44: {
                    if (templateStringTokener.optional(5) != null) {
                        expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, literals.toString())));
                        literals = new StringBuilder();
                        expressions.add(ParsedExpression.read((ZenTokener)templateStringTokener.toLiteral(environment.getEnvironment()), (IEnvironmentGlobal)environment));
                        templateStringTokener.required(6, "} expected");
                        continue block4;
                    }
                    literals.append('$');
                    continue block4;
                }
            }
            literals.append(token.getValue());
        }
        if (literals.length() > 0) {
            expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, literals.toString())));
        }
        if (expressions.isEmpty()) {
            expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, "")));
        }
        return expressions;
    }

    private static List<ParsedExpression> parse(List<Token> tokens, ZenPosition position, IEnvironmentGlobal environment) {
        ArrayList<ParsedExpression> expressions = new ArrayList<ParsedExpression>();
        StringBuilder literals = new StringBuilder();
        block4: for (int cursor = 0; cursor < tokens.size(); ++cursor) {
            Token token = tokens.get(cursor);
            switch (token.getType()) {
                case 197: {
                    TemplateString.handleEscapeChar(token, literals);
                    continue block4;
                }
                case 44: {
                    Token nextToken = tokens.get(++cursor);
                    if (nextToken.getType() == 5) {
                        expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, literals.toString())));
                        literals = new StringBuilder();
                        LiteralTokener literalTokener = LiteralTokener.create((PeekingIterator<Token>)Iterators.peekingIterator(tokens.subList(++cursor, tokens.size()).iterator()), environment.getEnvironment(), position.getFile());
                        expressions.add(ParsedExpression.read((ZenTokener)literalTokener, (IEnvironmentGlobal)environment));
                        nextToken = tokens.get(cursor += literalTokener.readTokenCount());
                        if (nextToken.getType() == 6) continue block4;
                        throw new ParseException(nextToken, "} expected");
                    }
                    throw new ParseException(token, "{ expected");
                }
                default: {
                    literals.append(token.getValue());
                }
            }
        }
        if (literals.length() > 0) {
            expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, literals.toString())));
        }
        if (expressions.isEmpty()) {
            expressions.add((ParsedExpression)new ParsedExpressionValue(position, (IPartialExpression)new ExpressionString(position, "")));
        }
        return expressions;
    }
}

