/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import crafttweaker.runtime.ScriptFile;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.value.IntRange;
import youyihj.zenutils.api.zenscript.IMultilinePreprocessor;

public class MixinPreprocessor
implements IMultilinePreprocessor {
    public static final String NAME = "mixin";
    private final String fileName;
    private final List<String> preprocessorLines;
    private final IntRange lineRange;
    private Pair<String, JsonElement> annotation;
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public MixinPreprocessor(String fileName, List<String> preprocessorLines, IntRange lineRange) {
        this.fileName = fileName;
        this.preprocessorLines = preprocessorLines;
        this.lineRange = lineRange;
    }

    @Override
    public IntRange getLineRange() {
        return this.lineRange;
    }

    @Override
    public List<String> getPreprocessorLines() {
        return this.preprocessorLines;
    }

    public String getPreprocessorName() {
        return NAME;
    }

    public void executeActionOnFind(ScriptFile scriptFile) {
        if (this.preprocessorLines.size() != 1) {
            this.processMultiline(scriptFile);
        } else {
            this.processSingleLine(scriptFile);
        }
    }

    public void executeActionOnFinish(ScriptFile scriptFile) {
    }

    public String getFileName() {
        return this.fileName;
    }

    public Pair<String, JsonElement> getAnnotation() {
        return this.annotation;
    }

    private void processMultiline(ScriptFile scriptFile) {
        String annotationContent;
        String annotationType = this.getPreprocessorLine().trim().substring(NAME.length() + 1).trim();
        if (annotationType.isEmpty()) {
            annotationType = "Mixin";
        }
        if (!(annotationContent = this.getPreprocessorLines().stream().skip(1L).map(it -> it.trim().substring(1)).collect(Collectors.joining())).isEmpty()) {
            try {
                this.annotation = Pair.of((Object)annotationType, (Object)GSON.fromJson(annotationContent, JsonElement.class));
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException(String.format("mixin annotation json is malformed, file: %s, line: [%d, %d]", scriptFile.getEffectiveName(), this.lineRange.getFrom(), this.lineRange.getTo()), e);
            }
        } else {
            this.annotation = Pair.of((Object)annotationType, (Object)new JsonObject());
        }
    }

    private void processSingleLine(ScriptFile scriptFile) {
        String annotationContent;
        String annotationType;
        String content = this.getPreprocessorLine().trim().substring(NAME.length() + 1).trim();
        int jsonStartIndex = content.indexOf(123);
        if (jsonStartIndex == -1) {
            jsonStartIndex = content.length();
        }
        if ((annotationType = content.substring(0, jsonStartIndex).trim()).isEmpty()) {
            annotationType = "Mixin";
        }
        if (!(annotationContent = content.substring(jsonStartIndex).trim()).isEmpty()) {
            try {
                this.annotation = Pair.of((Object)annotationType, (Object)GSON.fromJson(annotationContent, JsonElement.class));
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException(String.format("mixin annotation json is malformed, file: %s, line: %d", scriptFile.getEffectiveName(), this.getLineIndex()), e);
            }
        } else {
            this.annotation = Pair.of((Object)annotationType, (Object)new JsonObject());
        }
    }
}

