/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation;

import com.google.common.base.Preconditions;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.world.IWorld;
import java.util.HashMap;
import java.util.Queue;
import youyihj.zenutils.api.util.catenation.CatenationContext;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.ICatenationTaskQueueBuilderConsumer;
import youyihj.zenutils.impl.util.catenation.CatenationTaskQueueBuilder;

public class RepeatTask
implements ICatenationTask {
    private final ICatenationTaskQueueBuilderConsumer taskQueueBuilderConsumer;
    private final int times;
    private int hasRepeated;
    private int currentTaskIndex;
    private Queue<ICatenationTask> tasksInThisCycle;

    public RepeatTask(ICatenationTaskQueueBuilderConsumer taskQueueBuilderConsumer, int times) {
        Preconditions.checkArgument((times > 0 ? 1 : 0) != 0, (Object)"times must be greater than 0");
        this.taskQueueBuilderConsumer = taskQueueBuilderConsumer;
        this.times = times;
        this.initTaskCycle();
    }

    @Override
    public void run(IWorld world, CatenationContext context) {
        if (!this.tasksInThisCycle.isEmpty()) {
            ICatenationTask task = this.tasksInThisCycle.peek();
            task.run(world, context);
            if (task.isComplete()) {
                ++this.currentTaskIndex;
                this.tasksInThisCycle.poll();
            }
        } else if (!this.isComplete()) {
            ++this.hasRepeated;
            this.currentTaskIndex = 0;
            this.initTaskCycle();
            this.run(world, context);
        }
    }

    @Override
    public boolean isComplete() {
        return this.hasRepeated >= this.times;
    }

    @Override
    public IData serializeToData() {
        DataIntArray state = new DataIntArray(new int[]{this.currentTaskIndex, this.hasRepeated}, true);
        DataMap data = new DataMap(new HashMap(), false);
        if (this.tasksInThisCycle.peek() != null) {
            data.memberSet("task", this.tasksInThisCycle.peek().serializeToData());
        }
        data.memberSet("state", (IData)state);
        return data;
    }

    @Override
    public void deserializeFromData(IData data) {
        int[] state = data.memberGet("state").asIntArray();
        this.currentTaskIndex = state[0];
        this.hasRepeated = state[1];
        for (int i = 0; i < this.currentTaskIndex; ++i) {
            this.tasksInThisCycle.poll();
        }
        IData taskData = data.memberGet("task");
        if (taskData != null && this.tasksInThisCycle.peek() != null) {
            this.tasksInThisCycle.peek().deserializeFromData(taskData);
        }
    }

    private void initTaskCycle() {
        CatenationTaskQueueBuilder taskQueueBuilder = new CatenationTaskQueueBuilder();
        this.taskQueueBuilderConsumer.apply(taskQueueBuilder);
        this.tasksInThisCycle = taskQueueBuilder.build();
    }
}

