/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.world.MCWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.CatenationStatus;
import youyihj.zenutils.impl.util.catenation.persistence.CatenationPersistenceImpl;

@Mod.EventBusSubscriber
public class CatenationManager {
    private static final Multimap<World, Catenation> catenations = LinkedHashMultimap.create();
    private static final Multimap<World, Catenation> cantenationsToAdd = LinkedHashMultimap.create();
    private static final List<Catenation> clientCatenations = new ArrayList<Catenation>();
    private static final List<Catenation> clientCatenationsToAdd = new ArrayList<Catenation>();

    public static void addCatenation(World world, Catenation catenation) {
        cantenationsToAdd.put((Object)world, (Object)catenation);
    }

    public static void addClientCatenation(Catenation catenation) {
        clientCatenationsToAdd.add(catenation);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        switch (event.phase) {
            case START: {
                catenations.get((Object)event.world).removeIf(it -> it.tick((IWorld)new MCWorld(event.world)));
                break;
            }
            case END: {
                catenations.putAll(cantenationsToAdd);
                cantenationsToAdd.clear();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        catenations.get((Object)world).forEach(it -> it.getContext().setStatus(CatenationStatus.UNLOAD, (IWorld)new MCWorld(world)));
        catenations.removeAll((Object)world);
        cantenationsToAdd.removeAll((Object)world);
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            ImmutableList unfinished = ImmutableList.builder().addAll((Iterable)catenations.get((Object)world)).addAll((Iterable)cantenationsToAdd.get((Object)world)).build();
            CatenationPersistenceImpl.saveCatenations(CraftTweakerMC.getIWorld((World)world), (List<Catenation>)unfinished);
        }
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class ClientEventHandler {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                switch (event.phase) {
                    case START: {
                        clientCatenations.removeIf(it -> it.tick((IWorld)new MCWorld((World)world)));
                        break;
                    }
                    case END: {
                        clientCatenations.addAll(clientCatenationsToAdd);
                        clientCatenationsToAdd.clear();
                    }
                }
            } else if (!clientCatenations.isEmpty()) {
                clientCatenations.forEach(it -> it.getContext().setStatus(CatenationStatus.UNLOAD, it.getWorld()));
                clientCatenations.clear();
                clientCatenationsToAdd.clear();
            }
        }
    }
}

