/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either<Object, R>(null, right);
    }

    public Either<L, R> orElseLeft(Supplier<L> newLeftSupplier) {
        if (this.left == null) {
            return new Either<L, Object>(newLeftSupplier.get(), null);
        }
        return this;
    }

    public Either<L, R> orElseRight(Supplier<R> newRightSupplier) {
        if (this.left == null && this.right == null) {
            return new Either<Object, R>(null, newRightSupplier.get());
        }
        return this;
    }

    public Either<L, R> validateLeft(Predicate<L> leftPredicate) {
        if (this.left != null && leftPredicate.test(this.left)) {
            return this;
        }
        return new Either<Object, R>(null, this.right);
    }

    public Either<L, R> validateRight(Predicate<R> rightPredicate) {
        if (this.right != null && rightPredicate.test(this.right)) {
            return this;
        }
        return new Either<L, Object>(this.left, null);
    }

    public <T> T fold(Function<L, T> leftFolder, Function<R, T> rightFolder, Supplier<T> fallback) {
        if (this.left != null) {
            return leftFolder.apply(this.left);
        }
        if (this.right != null) {
            return rightFolder.apply(this.right);
        }
        return fallback.get();
    }

    public void fold(Consumer<L> leftConsumer, Consumer<R> rightConsumer, Runnable fallback) {
        if (this.left != null) {
            leftConsumer.accept(this.left);
        } else if (this.right != null) {
            rightConsumer.accept(this.right);
        } else {
            fallback.run();
        }
    }

    public boolean isEmpty() {
        return this.left == null && this.right == null;
    }
}

