/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util;

import crafttweaker.api.data.DataBool;
import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataByteArray;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import youyihj.zenutils.api.util.ExpandData;

public class DeepDataUpdater
implements IDataConverter<IData> {
    @Nullable
    private final IData data;
    @Nullable
    private final IData updateOperation;

    public DeepDataUpdater(IData data, IData updateOperation) {
        this.data = data;
        this.updateOperation = updateOperation;
    }

    public static IData deepUpdate(@Nullable IData data, @Nonnull IData toUpdate, @Nullable IData updateOperation) {
        return (IData)toUpdate.convert((IDataConverter)new DeepDataUpdater(data, updateOperation));
    }

    public IData fromBool(boolean value) {
        return new DataBool(value);
    }

    public IData fromByte(byte value) {
        return new DataByte(value);
    }

    public IData fromShort(short value) {
        return new DataShort(value);
    }

    public IData fromInt(int value) {
        return new DataInt(value);
    }

    public IData fromLong(long value) {
        return new DataLong(value);
    }

    public IData fromFloat(float value) {
        return new DataFloat(value);
    }

    public IData fromDouble(double value) {
        return new DataDouble(value);
    }

    public IData fromString(String value) {
        return new DataString(value);
    }

    public IData fromList(List<IData> values) {
        List<Object> newValues;
        block21: {
            List<IData> oldValues;
            block19: {
                int operator;
                block20: {
                    oldValues = Optional.ofNullable(this.data).map(IData::asList).orElse(Collections.emptyList());
                    newValues = new ArrayList(oldValues);
                    if (this.updateOperation == null) {
                        return new DataList(values, true);
                    }
                    if (DeepDataUpdater.isCollection(this.updateOperation)) break block19;
                    operator = this.updateOperation.asInt();
                    if ((operator & 4) == 0) break block20;
                    DataList toUpdate = new DataList(values, true);
                    switch (operator & 3) {
                        case 1: {
                            newValues.add(toUpdate);
                            break;
                        }
                        case 2: {
                            boolean contains = false;
                            for (IData oldValue : oldValues) {
                                if (!DeepDataUpdater.safeEquals((IData)toUpdate, oldValue)) continue;
                                contains = true;
                                break;
                            }
                            if (!contains) {
                                newValues.add(toUpdate);
                                break;
                            }
                            break block21;
                        }
                        case 3: {
                            newValues.removeIf(arg_0 -> DeepDataUpdater.lambda$fromList$0((IData)toUpdate, arg_0));
                            break;
                        }
                        default: {
                            newValues = Collections.singletonList(toUpdate);
                            break;
                        }
                    }
                    break block21;
                }
                switch (operator & 3) {
                    case 0: {
                        newValues = values;
                        break;
                    }
                    case 1: {
                        newValues.addAll(values);
                        break;
                    }
                    case 2: {
                        for (IData value : values) {
                            if (DeepDataUpdater.safeContains(oldValues, value)) continue;
                            newValues.add(value);
                        }
                        break block21;
                    }
                    case 3: {
                        if (values.isEmpty()) {
                            newValues.clear();
                            break;
                        }
                        newValues.removeIf(it -> DeepDataUpdater.safeContains(values, it));
                    }
                }
                break block21;
            }
            List operationsList = this.updateOperation.asList();
            IData operator = ExpandData.DataUpdateOperation.OVERWRITE;
            for (int i = 0; i < values.size(); ++i) {
                IData newValue;
                if (i < operationsList.size()) {
                    operator = (IData)operationsList.get(i);
                }
                if ((newValue = values.get(i)) == null) continue;
                if (i < oldValues.size()) {
                    IData oldValue = oldValues.get(i);
                    newValues.set(i, DeepDataUpdater.deepUpdate(oldValue, newValue, operator));
                    continue;
                }
                if ((operator.asInt() & 3) == 3) continue;
                newValues.add(newValue);
            }
        }
        return new DataList(newValues, true);
    }

    public IData fromMap(Map<String, IData> values) {
        if (this.updateOperation == null || !DeepDataUpdater.isMap(this.data)) {
            return new DataMap(values, true);
        }
        HashMap<String, IData> dataMap = new HashMap<String, IData>(this.data.asMap());
        if (DeepDataUpdater.isMap(this.updateOperation)) {
            values.forEach((key, value) -> dataMap.compute((String)key, (k, oldValue) -> DeepDataUpdater.deepUpdate(oldValue, value, this.updateOperation.memberGet(k))));
        } else {
            int operator = this.updateOperation.asInt();
            switch (operator & 3) {
                case 0: {
                    dataMap.clear();
                    dataMap.putAll(values);
                    break;
                }
                case 1: 
                case 2: {
                    values.forEach((key, value) -> dataMap.compute((String)key, (k, oldValue) -> DeepDataUpdater.deepUpdate(oldValue, value, (IData)new DataInt(operator))));
                    break;
                }
                case 3: {
                    if (values.isEmpty()) {
                        dataMap.clear();
                    }
                    for (String s : values.keySet()) {
                        dataMap.remove(s);
                    }
                    break;
                }
            }
        }
        return new DataMap(dataMap, true);
    }

    public IData fromByteArray(byte[] value) {
        if (this.data == null || this.updateOperation == null) {
            return new DataByteArray(value, true);
        }
        if (this.data instanceof DataList) {
            return this.fromList((List<IData>)new DataByteArray(value, true).asList());
        }
        byte[] origin = this.data.asByteArray();
        if (origin == null) {
            return new DataByteArray(value, true);
        }
        switch (this.updateOperation.asInt() & 3) {
            case 0: {
                return new DataByteArray(value, true);
            }
            case 1: {
                return new DataByteArray(ArrayUtils.addAll((byte[])origin, (byte[])value), true);
            }
            case 2: {
                return new DataByteArray(DeepDataUpdater.mergeByteArrays(origin, value), true);
            }
            case 3: {
                return new DataByteArray(value.length == 0 ? value : DeepDataUpdater.removeByteArrays(origin, value), true);
            }
        }
        return new DataByteArray(value, true);
    }

    public IData fromIntArray(int[] value) {
        if (this.data == null || this.updateOperation == null) {
            return new DataIntArray(value, true);
        }
        if (this.data instanceof DataList) {
            return this.fromList((List<IData>)new DataIntArray(value, true).asList());
        }
        int[] origin = this.data.asIntArray();
        if (origin == null) {
            return new DataIntArray(value, true);
        }
        switch (this.updateOperation.asInt() & 3) {
            case 0: {
                return new DataIntArray(value, true);
            }
            case 1: {
                return new DataIntArray(ArrayUtils.addAll((int[])origin, (int[])value), true);
            }
            case 2: {
                return new DataIntArray(DeepDataUpdater.mergeIntArrays(origin, value), true);
            }
            case 3: {
                return new DataIntArray(value.length == 0 ? value : DeepDataUpdater.removeIntArrays(origin, value), true);
            }
        }
        return new DataIntArray(value, true);
    }

    private static boolean isCollection(IData data) {
        return data != null && (data instanceof DataList || data instanceof DataIntArray || data instanceof DataByteArray || data.asList() != null);
    }

    private static boolean isMap(IData data) {
        return data instanceof DataMap;
    }

    private static boolean safeEquals(IData a, IData b) {
        return a == b || a != null && a.equals(b);
    }

    private static boolean safeContains(List<IData> data, IData element) {
        for (IData datum : data) {
            if (!DeepDataUpdater.safeEquals(datum, element)) continue;
            return true;
        }
        return false;
    }

    private static int[] mergeIntArrays(int[] a, int[] b) {
        boolean binarySearch = DeepDataUpdater.shouldBinarySearch(a.length, b.length);
        int[] checkArray = a;
        if (binarySearch) {
            checkArray = (int[])a.clone();
            Arrays.sort(checkArray);
        }
        int[] result = Arrays.copyOf(a, a.length + b.length);
        int addedIndex = a.length;
        for (int i : b) {
            if ((binarySearch ? Arrays.binarySearch(checkArray, i) : ArrayUtils.indexOf((int[])checkArray, (int)i)) == -1) continue;
            result[addedIndex++] = i;
        }
        return Arrays.copyOf(result, addedIndex);
    }

    private static byte[] mergeByteArrays(byte[] a, byte[] b) {
        boolean binarySearch = DeepDataUpdater.shouldBinarySearch(a.length, b.length);
        byte[] checkArray = a;
        if (binarySearch) {
            checkArray = (byte[])a.clone();
            Arrays.sort(checkArray);
        }
        byte[] result = Arrays.copyOf(a, a.length + b.length);
        int addedIndex = a.length;
        for (byte i : b) {
            if ((binarySearch ? Arrays.binarySearch(checkArray, i) : ArrayUtils.indexOf((byte[])checkArray, (byte)i)) == -1) continue;
            result[addedIndex++] = i;
        }
        return Arrays.copyOf(result, addedIndex);
    }

    private static int[] removeIntArrays(int[] array, int[] toRemove) {
        boolean binarySearch = DeepDataUpdater.shouldBinarySearch(array.length, toRemove.length);
        int[] checkArray = array;
        if (binarySearch) {
            checkArray = (int[])array.clone();
            Arrays.sort(checkArray);
        }
        int[] result = new int[array.length];
        int addedIndex = 0;
        for (int i : array) {
            if ((binarySearch ? Arrays.binarySearch(checkArray, i) : ArrayUtils.indexOf((int[])checkArray, (int)i)) == -1) continue;
            result[addedIndex++] = i;
        }
        return Arrays.copyOf(result, addedIndex);
    }

    private static byte[] removeByteArrays(byte[] array, byte[] toRemove) {
        boolean binarySearch = DeepDataUpdater.shouldBinarySearch(array.length, toRemove.length);
        byte[] checkArray = array;
        if (binarySearch) {
            checkArray = (byte[])array.clone();
            Arrays.sort(checkArray);
        }
        byte[] result = new byte[array.length];
        int addedIndex = 0;
        for (byte i : array) {
            if ((binarySearch ? Arrays.binarySearch(checkArray, i) : ArrayUtils.indexOf((byte[])checkArray, (byte)i)) == -1) continue;
            result[addedIndex++] = i;
        }
        return Arrays.copyOf(result, addedIndex);
    }

    private static boolean shouldBinarySearch(int total, int items) {
        return items > Math.max(2, Integer.highestOneBit(total));
    }

    private static /* synthetic */ boolean lambda$fromList$0(IData toUpdate, IData it) {
        return DeepDataUpdater.safeEquals(toUpdate, it);
    }

    public static class Operation {
        public static final int OVERWRITE = 0;
        public static final int APPEND = 1;
        public static final int MERGE = 2;
        public static final int REMOVE = 3;
        public static final int BUMP = 4;
        private static final int SUB_OPERATOR_MASK = 3;
    }
}

