/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import crafttweaker.IAction;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.reload.ActionReloadCallback;
import youyihj.zenutils.impl.util.SimpleCache;

public class AnnotatedActionReloadCallback
extends ActionReloadCallback<IAction> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final SimpleCache<Class<?>, MethodHandle> APPLY_RELOAD_METHOD_CACHE = new SimpleCache<Class, MethodHandle>(AnnotatedActionReloadCallback::findApplyReloadMethod);
    private static final SimpleCache<Class<?>, MethodHandle> UNDO_METHOD_CACHE = new SimpleCache<Class, MethodHandle>(AnnotatedActionReloadCallback::findUndoMethod);
    private final MethodHandle applyReloadMethod;
    private final MethodHandle undoMethod;

    public AnnotatedActionReloadCallback(IAction action) {
        super(action);
        this.applyReloadMethod = APPLY_RELOAD_METHOD_CACHE.get(action.getClass());
        this.undoMethod = UNDO_METHOD_CACHE.get(action.getClass());
    }

    @Override
    public void applyReload() {
        if (this.applyReloadMethod != null) {
            try {
                this.applyReloadMethod.invoke(this.action);
            }
            catch (Throwable e) {
                ZenUtils.forgeLogger.error("Failed to invoke applyReload method", e);
            }
        } else {
            this.action.apply();
        }
    }

    @Override
    public void undo() {
        if (this.undoMethod != null) {
            try {
                this.undoMethod.invoke(this.action);
            }
            catch (Throwable e) {
                ZenUtils.forgeLogger.error("Failed to invoke undo method", e);
            }
        }
    }

    @Override
    public boolean hasUndoMethod() {
        return this.undoMethod != null;
    }

    private static MethodHandle findUndoMethod(Class<?> clazz) {
        try {
            return LOOKUP.findVirtual(clazz, "undo", MethodType.methodType(Void.TYPE));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle findApplyReloadMethod(Class<?> clazz) {
        try {
            return LOOKUP.findVirtual(clazz, "applyReload", MethodType.methodType(Void.TYPE));
        }
        catch (Exception e) {
            return null;
        }
    }
}

