/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.player;

import com.google.common.base.Throwables;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import youyihj.zenutils.api.network.ZenNetworkHandler;
import youyihj.zenutils.api.player.IActionResult;
import youyihj.zenutils.impl.player.ActionResult;
import youyihj.zenutils.impl.player.InteractBlockContext;

public class PlayerInteractionSimulation {
    private static final String INTERACT_ENTITY_MESSAGE_KEY = "zenutils.internal.interactEntity";

    public static IActionResult<EnumActionResult> simulateRightClickItem(IPlayer player, IItemStack stack, IEntityEquipmentSlot hand) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        EnumHand mcHand = hand == null ? EnumHand.MAIN_HAND : CraftTweakerMC.getHand((IEntityEquipmentSlot)hand);
        ItemStack mcItem = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (mcPlayer instanceof EntityPlayerMP) {
            return PlayerInteractionSimulation.ghostItemOperation(mcPlayer, mcItem, mcHand, () -> {
                PlayerInteractionManager interactionManager = ((EntityPlayerMP)mcPlayer).field_71134_c;
                return interactionManager.func_187250_a(mcPlayer, mcPlayer.field_70170_p, mcItem, mcHand);
            });
        }
        return new ActionResult<EnumActionResult>(mcItem, EnumActionResult.PASS);
    }

    public static IActionResult<EnumActionResult> simulateRightClickBlock(IPlayer player, IItemStack stack, IEntityEquipmentSlot hand, IBlockPos pos, IFacing facing, float hitX, float hitY, float hitZ) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        InteractBlockContext context = new InteractBlockContext(mcPlayer, CraftTweakerMC.getBlockPos((IBlockPos)pos), CraftTweakerMC.getFacing((IFacing)facing), hitX, hitY, hitZ);
        ItemStack mcItem = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (mcPlayer instanceof EntityPlayerMP) {
            EnumHand mcHand = hand == null ? EnumHand.MAIN_HAND : CraftTweakerMC.getHand((IEntityEquipmentSlot)hand);
            return PlayerInteractionSimulation.ghostItemOperation(mcPlayer, mcItem, mcHand, () -> {
                PlayerInteractionManager interactionManager = ((EntityPlayerMP)mcPlayer).field_71134_c;
                return interactionManager.func_187251_a(mcPlayer, mcPlayer.field_70170_p, mcItem, mcHand, context.getPos(), context.getSide(), context.getHitX(), context.getHitY(), context.getHitZ());
            });
        }
        return new ActionResult<EnumActionResult>(mcItem, EnumActionResult.PASS);
    }

    public static IActionResult<EnumActionResult> simulateRightClickEntity(IPlayer player, IEntity entity, IItemStack stack, IEntityEquipmentSlot hand) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        Entity mcEntity = CraftTweakerMC.getEntity((IEntity)entity);
        EnumHand mcHand = hand == null ? EnumHand.MAIN_HAND : CraftTweakerMC.getHand((IEntityEquipmentSlot)hand);
        ZenNetworkHandler.sendTo(INTERACT_ENTITY_MESSAGE_KEY, player, byteBuf -> {
            byteBuf.writeInt(mcEntity.func_145782_y());
            byteBuf.writeItemStack(stack);
            byteBuf.writeBoolean(mcHand == EnumHand.MAIN_HAND);
        });
        return PlayerInteractionSimulation.ghostItemOperation(mcPlayer, CraftTweakerMC.getItemStack((IItemStack)stack), mcHand, () -> mcPlayer.func_190775_a(mcEntity, mcHand));
    }

    public static IActionResult<Void> simulateLeftClickBlock(IPlayer player, IItemStack stack, IBlockPos pos, IFacing side) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        InteractBlockContext context = new InteractBlockContext(mcPlayer, CraftTweakerMC.getBlockPos((IBlockPos)pos), CraftTweakerMC.getFacing((IFacing)side));
        if (mcPlayer instanceof EntityPlayerMP) {
            return PlayerInteractionSimulation.ghostItemOperation(mcPlayer, CraftTweakerMC.getItemStack((IItemStack)stack), EnumHand.MAIN_HAND, () -> {
                PlayerInteractionManager interactionManager = ((EntityPlayerMP)mcPlayer).field_71134_c;
                interactionManager.func_180784_a(context.getPos(), context.getSide());
                return null;
            });
        }
        return new ActionResult<Object>(ItemStack.field_190927_a, null);
    }

    public static IItemStack simulateUseItemFinish(IPlayer player, IItemStack itemStack, IEntityEquipmentSlot hand) {
        ItemStack mcItem = CraftTweakerMC.getItemStack((IItemStack)itemStack);
        EnumHand mcHand = CraftTweakerMC.getHand((IEntityEquipmentSlot)hand);
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (mcHand == null) {
            mcHand = mcPlayer.func_184600_cs();
        }
        return PlayerInteractionSimulation.ghostItemOperation(mcPlayer, mcItem, mcHand, () -> {
            ItemStack result = mcItem.func_77950_b(CraftTweakerMC.getWorld((IWorld)player.getWorld()), (EntityLivingBase)mcPlayer);
            result = ForgeEventFactory.onItemUseFinish((EntityLivingBase)mcPlayer, (ItemStack)mcItem.func_77946_l(), (int)mcItem.func_77988_m(), (ItemStack)result);
            return CraftTweakerMC.getIItemStack((ItemStack)result);
        }).getResult();
    }

    public static void registerNetworkMessage() {
        ZenNetworkHandler.registerServer2ClientMessage(INTERACT_ENTITY_MESSAGE_KEY, (player, byteBuf) -> {
            World world = CraftTweakerMC.getWorld((IWorld)player.getWorld());
            Entity entity = world.func_73045_a(byteBuf.readInt());
            IItemStack itemStack = byteBuf.readItemStack();
            if (entity != null) {
                EnumHand hand = byteBuf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
                PlayerInteractionSimulation.ghostItemOperation(mcPlayer, CraftTweakerMC.getItemStack((IItemStack)itemStack), hand, () -> mcPlayer.func_190775_a(entity, hand));
            }
        });
    }

    private static <T> IActionResult<T> ghostItemOperation(EntityPlayer player, ItemStack item, EnumHand hand, Callable<T> operation) {
        ItemStack origin = player.func_184586_b(hand);
        player.func_184611_a(hand, item);
        try {
            T result = operation.call();
            ActionResult<T> actionResult = new ActionResult<T>(player.func_184586_b(hand), result);
            return actionResult;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            player.func_184611_a(hand, origin);
        }
    }
}

