/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import java.util.Arrays;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import stanhebben.zenscript.ZenModule;
import youyihj.zenutils.api.network.IByteBuf;
import youyihj.zenutils.impl.network.PlayerScriptValidation;
import youyihj.zenutils.impl.network.ZenUtilsMessage;

public class ValidateScriptMessage
extends ZenUtilsMessage {
    private int scriptBytesHash;
    private String scriptClassName;

    public ValidateScriptMessage() {
    }

    public ValidateScriptMessage(byte[] scriptBytes, String scriptClassName) {
        this.setKey("validate_script");
        this.scriptBytesHash = Arrays.hashCode(scriptBytes);
        this.scriptClassName = scriptClassName;
    }

    @Override
    protected void writeExtraBytes(IByteBuf buf) {
        buf.writeString(this.scriptClassName);
        buf.writeInt(this.scriptBytesHash);
    }

    @Override
    protected void readExtraBytes(IByteBuf buf) {
        this.scriptClassName = buf.readString();
        this.scriptBytesHash = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<ValidateScriptMessage, IMessage> {
        public IMessage onMessage(ValidateScriptMessage message, MessageContext ctx) {
            byte[] serverScriptBytes = (byte[])ZenModule.classes.get(message.scriptClassName);
            if (serverScriptBytes != null && Arrays.hashCode(serverScriptBytes) == message.scriptBytesHash) {
                PlayerScriptValidation.ServerEventHandler.validatedScriptsByPlayer.put((Object)ctx.getServerHandler().field_147369_b, (Object)message.scriptClassName);
            }
            return null;
        }
    }
}

