/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import stanhebben.zenscript.ZenModule;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.world.ZenUtilsWorld;
import youyihj.zenutils.impl.network.ZenUtilsNetworkHandler;

public class PlayerScriptValidation {
    public static boolean isZenScriptAnonymousFunction(byte[] bytecodes) {
        ClassReader cr = new ClassReader(bytecodes);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 1);
        return classNode.interfaces.size() == 1 && !classNode.methods.stream().anyMatch(it -> "__script__".equals(it.name)) && (classNode.access & 0x1000) == 0 && !classNode.name.startsWith("any") && !"__ZenMain__".equals(classNode.name);
    }

    public static final class ServerEventHandler {
        static Multimap<EntityPlayerMP, String> validatedScriptsByPlayer = Multimaps.newSetMultimap(new WeakHashMap(), HashSet::new);
        private static final Supplier<Set<String>> shouldValidatedScripts = Suppliers.memoize(() -> {
            HashSet<String> scripts = new HashSet<String>();
            for (Map.Entry entry : ZenModule.classes.entrySet()) {
                String name = (String)entry.getKey();
                byte[] bytecode = (byte[])entry.getValue();
                if (bytecode.length == 0 || !PlayerScriptValidation.isZenScriptAnonymousFunction(bytecode)) continue;
                scripts.add(name);
            }
            scripts.removeAll(ZenUtilsNetworkHandler.INSTANCE.validationBlacklist);
            return scripts;
        });

        @SubscribeEvent
        public static void onEntityJoin(EntityJoinWorldEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                ZenUtilsWorld.catenation(CraftTweakerMC.getIWorld((World)event.getWorld())).sleep(100L).then((w, ctx) -> {
                    Collection validClientScripts = validatedScriptsByPlayer.get((Object)player);
                    validClientScripts.removeAll(ZenUtilsNetworkHandler.INSTANCE.validationBlacklist);
                    if (!validClientScripts.equals(shouldValidatedScripts.get())) {
                        player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("message.zenutils.validate", new Object[0]));
                    } else {
                        ZenUtils.forgeLogger.info("Validated scripts of client {}", (Object)player.func_70005_c_());
                    }
                }).stopWhen((w, ctx) -> !entity.func_70089_S() || !entity.isAddedToWorld()).start();
            }
        }
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static final class ClientEventHandler {
        @SubscribeEvent
        public static void onEntityJoin(EntityJoinWorldEvent event) {
            if (ZenUtilsNetworkHandler.INSTANCE.shouldSendScripts() && ClientEventHandler.runsOnMultiplayer() && event.getWorld().field_72995_K && event.getEntity().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ClientEventHandler.sendScriptsToServer();
            }
        }

        private static void sendScriptsToServer() {
            for (Map.Entry entry : ZenModule.classes.entrySet()) {
                String name = (String)entry.getKey();
                byte[] bytecode = (byte[])entry.getValue();
                if (bytecode.length == 0 || !PlayerScriptValidation.isZenScriptAnonymousFunction(bytecode)) continue;
                ZenUtilsNetworkHandler.INSTANCE.sendValidateScriptMessage(bytecode, name);
            }
        }

        private static boolean runsOnMultiplayer() {
            return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
        }
    }
}

