/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.mixin.crafttweaker;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.ZenTypeAssociative;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ClassDataFetcher;
import youyihj.zenutils.impl.member.LiteralType;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.nat.NativeClassValidate;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNative;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNativeIterable;

@Mixin(value={TypeRegistry.class}, remap=false)
public abstract class MixinTypeRegistry
implements ITypeRegistry {
    @Shadow
    @Final
    private Map<Class<?>, ZenType> types;
    private final Map<String, ZenType> literalTypes = InternalUtils.make(new HashMap(), map -> {
        map.put("Ljava/lang/Object;", ZenTypeJavaNative.OBJECT);
        map.put("Ljava/lang/String;", ZenType.STRING);
    });

    @Shadow
    public abstract ZenType getType(Type var1);

    @Inject(method={"getType"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleComplexTypes(Type type, CallbackInfoReturnable<ZenType> cir) {
        if (type instanceof LiteralType) {
            if (this.literalTypes.containsKey(type.toString())) {
                cir.setReturnValue((Object)this.literalTypes.get(type.toString()));
            } else {
                ZenType zenLiteralType = this.zu$handleLiteralType(type.toString());
                this.literalTypes.put(type.toString(), zenLiteralType);
                cir.setReturnValue((Object)zenLiteralType);
            }
        }
        if (type instanceof TypeVariable) {
            cir.setReturnValue((Object)this.getType(((TypeVariable)type).getBounds()[0]));
        }
        if (type instanceof GenericArrayType) {
            cir.setReturnValue((Object)new ZenTypeArrayBasic(this.getType(((GenericArrayType)type).getGenericComponentType())));
        }
    }

    @ModifyReturnValue(method={"getType"}, at={@At(value="RETURN")}, slice={@Slice(from=@At(value="CONSTANT", args={"nullValue=true"}))})
    private ZenType modifyTypeFallback(ZenType original) {
        return ZenTypeJavaNative.OBJECT;
    }

    @Inject(method={"getClassType"}, at={@At(value="NEW", target="stanhebben/zenscript/type/ZenTypeNative")}, cancellable=true)
    private void redirectToJavaNative(Class<?> cls, CallbackInfoReturnable<ZenType> cir) {
        ClassData classData = InternalUtils.getClassDataFetcher().forClass(cls);
        if (NativeClassValidate.isValid(classData)) {
            cir.setReturnValue((Object)new ZenTypeJavaNative(classData, this));
            this.types.put(cls, (ZenType)cir.getReturnValue());
        }
    }

    @Inject(method={"getType"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/compiler/TypeRegistry;getClassType(Ljava/lang/Class;)Lstanhebben/zenscript/type/ZenType;", ordinal=0)}, cancellable=true)
    private void getIterableType(Type type, CallbackInfoReturnable<ZenType> cir, @Local ParameterizedType pType, @Local Class<?> rawClass) {
        ClassDataFetcher classDataFetcher = InternalUtils.getClassDataFetcher();
        if (classDataFetcher.forClass(Iterable.class).isAssignableFrom(classDataFetcher.forClass(rawClass))) {
            cir.setReturnValue((Object)new ZenTypeJavaNativeIterable(classDataFetcher.forClass(rawClass), this.getType(pType.getActualTypeArguments()[0]), this));
        }
    }

    @Unique
    private ZenType zu$handleLiteralType(String name) {
        ClassDataFetcher classDataFetcher = InternalUtils.getClassDataFetcher();
        if (name.startsWith("L")) {
            if (!name.contains("<")) {
                String className = name.substring(1, name.length() - 1).replace('/', '.');
                try {
                    ClassData classData = classDataFetcher.forName(className);
                    return this.zu$checkNative(classData);
                }
                catch (ClassNotFoundException e) {
                    return ZenTypeJavaNative.OBJECT;
                }
            }
            try {
                String genericInfo = name.substring(name.indexOf("<") + 1, name.lastIndexOf(">"));
                String rawClassName = name.substring(1, name.indexOf("<")).replace('/', '.');
                String[] genericTypes = genericInfo.split(",");
                ClassData rawClassData = classDataFetcher.forName(rawClassName);
                if (genericTypes.length == 1 && classDataFetcher.forClass(List.class).isAssignableFrom(rawClassData)) {
                    return new ZenTypeArrayList(this.getType(new LiteralType(genericTypes[0])));
                }
                if (genericTypes.length == 2 && classDataFetcher.forClass(Map.class).isAssignableFrom(rawClassData)) {
                    return new ZenTypeAssociative(this.getType(new LiteralType(genericTypes[1])), this.getType(new LiteralType(genericTypes[0])));
                }
                return this.zu$checkNative(rawClassData);
            }
            catch (ClassNotFoundException e) {
                return ZenTypeJavaNative.OBJECT;
            }
        }
        if (name.startsWith("[")) {
            return new ZenTypeArrayBasic(this.getType(new LiteralType(name.substring(1))));
        }
        return ZenTypeJavaNative.OBJECT;
    }

    @Unique
    private ZenTypeJavaNative zu$checkNative(ClassData classData) {
        if (NativeClassValidate.isValid(classData)) {
            return new ZenTypeJavaNative(classData, this);
        }
        return ZenTypeJavaNative.OBJECT;
    }

    @Overwrite
    private ZenType getListType(ParameterizedType type) {
        return new ZenTypeArrayList(this.getType(type.getActualTypeArguments()[0]));
    }

    @Overwrite
    private ZenType getMapType(ParameterizedType type) {
        return new ZenTypeAssociative(this.getType(type.getActualTypeArguments()[1]), this.getType(type.getActualTypeArguments()[0]));
    }
}

