/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.mixin.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.preprocessor.IPreprocessor;
import crafttweaker.preprocessor.PreprocessorFactory;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.ScriptFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import stanhebben.zenscript.value.IntRange;
import youyihj.zenutils.api.zenscript.IMultilinePreprocessorFactory;

@Mixin(value={PreprocessorManager.class}, remap=false)
public abstract class MixinPreprocessorManager {
    @Shadow
    private HashMap<String, PreprocessorFactory<?>> registeredPreprocessorActions;

    @Shadow
    protected abstract void addPreprocessorToFileMap(String var1, IPreprocessor var2);

    @Overwrite
    public List<IPreprocessor> checkFileForPreprocessors(ScriptFile scriptFile) {
        ArrayList<IPreprocessor> preprocessorList = new ArrayList<IPreprocessor>();
        String filename = scriptFile.getName();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(scriptFile.open(), StandardCharsets.UTF_8));
            String line = "";
            String content = "";
            int lineIndex = -1;
            boolean readCurrentLineAgain = false;
            while (true) {
                if (!readCurrentLineAgain) {
                    line = reader.readLine();
                    if (line == null) break;
                    ++lineIndex;
                    content = line.trim();
                } else {
                    readCurrentLineAgain = false;
                }
                if (content.isEmpty() || content.charAt(0) != '#') continue;
                String[] splits = (content = content.substring(1)).split(" ");
                PreprocessorFactory<?> preprocessorFactory = this.registeredPreprocessorActions.get(splits[0]);
                if (preprocessorFactory instanceof IMultilinePreprocessorFactory) {
                    IMultilinePreprocessorFactory multilinePreprocessorFactory = (IMultilinePreprocessorFactory)preprocessorFactory;
                    ArrayList<String> multilines = new ArrayList<String>();
                    multilines.add(line);
                    int startIndex = lineIndex;
                    while ((line = reader.readLine()) != null) {
                        ++lineIndex;
                        content = line.trim();
                        if (content.isEmpty() || content.charAt(0) != '#') break;
                        splits = content.substring(1).split(" ");
                        if (this.registeredPreprocessorActions.containsKey(splits[0])) {
                            readCurrentLineAgain = true;
                            break;
                        }
                        multilines.add(line);
                    }
                    Object preprocessor = multilinePreprocessorFactory.createPreprocessor(scriptFile.getName(), multilines, new IntRange(startIndex, lineIndex - 1));
                    preprocessor.executeActionOnFind(scriptFile);
                    preprocessorList.add((IPreprocessor)preprocessor);
                    this.addPreprocessorToFileMap(scriptFile.getEffectiveName(), (IPreprocessor)preprocessor);
                    continue;
                }
                if (preprocessorFactory == null) continue;
                IPreprocessor preprocessor = preprocessorFactory.createPreprocessor(scriptFile.getName(), line, lineIndex);
                preprocessor.executeActionOnFind(scriptFile);
                preprocessorList.add(preprocessor);
                this.addPreprocessorToFileMap(scriptFile.getEffectiveName(), preprocessor);
            }
        }
        catch (IOException e) {
            CraftTweakerAPI.logError((String)("Could not read preprocessor functions in " + filename), (Throwable)e);
        }
        return preprocessorList;
    }
}

