/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.mixin.crafttweaker;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassWriter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.EnvironmentScript;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.definitions.zenclasses.ParsedClassConstructor;
import stanhebben.zenscript.definitions.zenclasses.ParsedZenClass;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.reflect.ReflectionClassData;
import youyihj.zenutils.impl.mixin.itf.IEnvironmentClassExtension;
import youyihj.zenutils.impl.mixin.itf.IParsedClassConstructorExtension;
import youyihj.zenutils.impl.mixin.itf.IParsedZenClassExtension;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.MixinPreprocessor;
import youyihj.zenutils.impl.zenscript.mixin.ExpressionMixinThis;
import youyihj.zenutils.impl.zenscript.mixin.MixinAnnotationTranslator;
import youyihj.zenutils.impl.zenscript.mixin.ZenMixin;
import youyihj.zenutils.impl.zenscript.nat.ExpressionSuper;
import youyihj.zenutils.impl.zenscript.nat.NativeClassValidate;
import youyihj.zenutils.impl.zenscript.nat.ParsedZenClassCompile;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNative;

@Mixin(value={ParsedZenClass.class}, remap=false)
public abstract class MixinParsedZenClass
implements IParsedZenClassExtension {
    @Shadow
    @Final
    public ZenPosition position;
    @Shadow
    @Final
    @Mutable
    public String className;
    @Shadow
    public Class<?> thisClass;
    @Shadow
    @Final
    public String name;
    @Unique
    List<MixinPreprocessor> preprocessors;
    @Unique
    List<String> mixinTargets;
    @Unique
    ZenTypeJavaNative superClass;
    @Unique
    List<ZenTypeJavaNative> interfaces = new ArrayList<ZenTypeJavaNative>();

    @Inject(method={"parse"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/ZenTokener;required(ILjava/lang/String;)Lstanhebben/zenscript/parser/Token;", ordinal=1)})
    private static void readParentClasses(ZenTokener parser, IEnvironmentGlobal environmentGlobal, CallbackInfoReturnable<ParsedZenClass> cir, @Share(value="superClass") LocalRef<ZenTypeJavaNative> superClass, @Share(value="interfaces") LocalRef<List<ZenTypeJavaNative>> interfacesRef) {
        ArrayList<ZenTypeJavaNative> interfaces = new ArrayList<ZenTypeJavaNative>();
        Token extendsKeyword = parser.optional(1);
        if (extendsKeyword != null && extendsKeyword.getValue().equals("extends")) {
            ZenType firstSuperClass = ZenType.read((ZenTokener)parser, (IEnvironmentGlobal)environmentGlobal);
            if (firstSuperClass instanceof ZenTypeJavaNative) {
                ZenTypeJavaNative firstSuperClass1 = (ZenTypeJavaNative)firstSuperClass;
                if (firstSuperClass1.getClassData().isInterface()) {
                    interfaces.add(firstSuperClass1);
                } else {
                    superClass.set((Object)firstSuperClass1);
                }
            } else {
                environmentGlobal.error(parser.peek().getPosition(), "super class only supports native type currently");
            }
            while (parser.optional(11) != null) {
                ZenType interfaceType = ZenType.read((ZenTokener)parser, (IEnvironmentGlobal)environmentGlobal);
                if (interfaceType instanceof ZenTypeJavaNative) {
                    ZenTypeJavaNative interfaceJavaType = (ZenTypeJavaNative)interfaceType;
                    if (interfaceJavaType.getClassData().isInterface()) {
                        interfaces.add(interfaceJavaType);
                        continue;
                    }
                    environmentGlobal.error(parser.peek().getPosition(), "only multi-inheritance interfaces");
                    continue;
                }
                environmentGlobal.error(parser.peek().getPosition(), "super class only supports native type currently");
            }
        }
        interfacesRef.set(interfaces);
    }

    @Inject(method={"parse"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/compiler/EnvironmentScript;putValue(Ljava/lang/String;Lstanhebben/zenscript/symbols/IZenSymbol;Lstanhebben/zenscript/util/ZenPosition;)V")})
    private static void setParentClasses(ZenTokener parser, IEnvironmentGlobal environmentGlobal, CallbackInfoReturnable<ParsedZenClass> cir, @Local ParsedZenClass classTemplate, @Share(value="superClass") LocalRef<ZenTypeJavaNative> superClass, @Share(value="interfaces") LocalRef<List<ZenTypeJavaNative>> interfacesRef) {
        ((IParsedZenClassExtension)classTemplate).setSuperClass((ZenTypeJavaNative)((Object)superClass.get()));
        ((IParsedZenClassExtension)classTemplate).setInterfaces((List)interfacesRef.get());
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAnnotation(ZenPosition position, String name, String className, EnvironmentScript classEnvironment, CallbackInfo ci) {
        this.preprocessors = MixinAnnotationTranslator.findAnnotation(position);
        for (MixinPreprocessor preprocessor : this.preprocessors) {
            Pair<String, JsonElement> annotation = preprocessor.getAnnotation();
            if (!((String)annotation.getLeft()).equals("Mixin")) continue;
            boolean isMixinClass = true;
            this.mixinTargets = MixinAnnotationTranslator.getMixinTargets(((JsonElement)annotation.getRight()).getAsJsonObject());
            for (String target : this.mixinTargets) {
                if (target.startsWith("youyihj")) {
                    throw new IllegalArgumentException("why you try to mixin zenutils itself?");
                }
                try {
                    ClassData classData = InternalUtils.getClassDataFetcher().forName(target);
                    if (classData instanceof ReflectionClassData) {
                        if (InternalUtils.getScriptStatus() != ScriptStatus.INIT) continue;
                        isMixinClass = false;
                        classEnvironment.info("Skip loading mixin class " + name + ", because the target " + target + " is a non-mod class or already loaded");
                        continue;
                    }
                    if (NativeClassValidate.isValid(classData, true)) continue;
                    isMixinClass = false;
                    classEnvironment.info("Skip loading mixin class " + name + ", because the target " + target + " is not accessible");
                }
                catch (ClassNotFoundException e) {
                    isMixinClass = false;
                    classEnvironment.info("Skip loading mixin class " + name + ", because the target " + target + " is not found");
                }
            }
            if (!isMixinClass) break;
            this.className = ZenMixin.handleMixinClassName(name);
            break;
        }
    }

    @ModifyConstant(method={"writeClass"}, constant={@Constant(stringValue="java/lang/Object")})
    private String setSuperClassASM(String original) {
        if (this.superClass != null) {
            return this.superClass.getClassData().internalName();
        }
        return original;
    }

    @ModifyArg(method={"writeClass"}, at=@At(value="INVOKE", target="Lorg/objectweb/asm/ClassWriter;visit(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V"))
    private String[] setInterfacesASM(String[] original) {
        return (String[])this.interfaces.stream().map(it -> it.getClassData().internalName()).toArray(String[]::new);
    }

    @Inject(method={"writeClass"}, at={@At(value="INVOKE", target="Lorg/objectweb/asm/ClassWriter;visit(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    private void applyAnnotation(IEnvironmentGlobal environmentGlobal, CallbackInfo ci, @Local ClassWriter cw) {
        for (MixinPreprocessor mixinPreprocessor : this.preprocessors) {
            Pair<String, JsonElement> annotation = mixinPreprocessor.getAnnotation();
            MixinAnnotationTranslator.translate((String)annotation.getLeft(), (JsonElement)annotation.getRight(), (arg_0, arg_1) -> ((ClassWriter)cw).visitAnnotation(arg_0, arg_1), it -> new ParseException(this.position.getFile(), this.position.getLine() - 1, 0, it));
        }
    }

    @Inject(method={"writeClass"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/compiler/IEnvironmentGlobal;putClass(Ljava/lang/String;[B)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void fixClassCompile(IEnvironmentGlobal environmentGlobal, CallbackInfo ci, @Local byte[] thisClassArray) {
        this.thisClass = this.className.startsWith("youyihj/zenutils/impl/mixin") ? Object.class : ParsedZenClassCompile.compile(this.className, thisClassArray);
        ci.cancel();
    }

    @WrapOperation(method={"writeClass"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/compiler/EnvironmentClass;putValue(Ljava/lang/String;Lstanhebben/zenscript/symbols/IZenSymbol;Lstanhebben/zenscript/util/ZenPosition;)V")})
    private void injectSymbols(EnvironmentClass instance, String name, IZenSymbol value, ZenPosition position, Operation<Void> original) {
        original.call(new Object[]{instance, name, value, position});
        if (this.mixinTargets != null && this.mixinTargets.size() == 1) {
            instance.putValue("this0", position1 -> new ExpressionMixinThis(position1, this.mixinTargets.get(0).replace('.', '/'), (IEnvironmentGlobal)instance), position);
            ((IEnvironmentClassExtension)instance).setMixinTargets(this.mixinTargets);
            ArrayList<ZenTypeJavaNative> superClasses = new ArrayList<ZenTypeJavaNative>(this.interfaces);
            if (this.superClass != null) {
                superClasses.add(this.superClass);
            }
            ((IEnvironmentClassExtension)instance).setSubClasses(superClasses);
        }
        if (this.superClass != null) {
            instance.putValue("super", position1 -> new ExpressionSuper(position1, this.superClass), position);
        }
    }

    @Inject(method={"getMember"}, at={@At(value="INVOKE", target="Lstanhebben/zenscript/compiler/IEnvironmentGlobal;error(Ljava/lang/String;)V")}, cancellable=true)
    private void addSuperMembers(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name, boolean isStatic, CallbackInfoReturnable<IPartialExpression> cir) {
        IPartialExpression superClassMember;
        if (this.superClass != null && !((superClassMember = this.superClass.getMember(position, environment, value, name, false)) instanceof ExpressionInvalid)) {
            cir.setReturnValue((Object)superClassMember);
            return;
        }
        for (ZenTypeJavaNative anInterface : this.interfaces) {
            IPartialExpression interfaceMember = anInterface.getMember(position, environment, value, name, false);
            if (interfaceMember instanceof ExpressionInvalid) continue;
            cir.setReturnValue((Object)interfaceMember);
            return;
        }
    }

    @Inject(method={"addConstructor"}, at={@At(value="HEAD")})
    private void setConstructorOwner(ParsedClassConstructor parsedClassConstructor, CallbackInfo ci) {
        ((IParsedClassConstructorExtension)parsedClassConstructor).setSuperClass(this.superClass);
    }

    @Override
    public ZenTypeJavaNative getSuperClass() {
        return this.superClass;
    }

    @Override
    public void setSuperClass(ZenTypeJavaNative superClass) {
        this.superClass = superClass;
    }

    @Override
    public List<ZenTypeJavaNative> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public void setInterfaces(List<ZenTypeJavaNative> interfaces) {
        this.interfaces = interfaces;
    }
}

