/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.member.reflect.ReflectionAnnotatedMember;
import youyihj.zenutils.impl.member.reflect.ReflectionClassData;
import youyihj.zenutils.impl.member.reflect.ReflectionClassDataFetcher;

public class ReflectionExecutableData
extends ReflectionAnnotatedMember
implements ExecutableData {
    private static final Logger LOGGER = LogManager.getLogger((String)"ReflectionExecutableData");
    private final Executable executable;
    private TypeData returnType;
    private List<TypeData> parameters;

    public ReflectionExecutableData(Executable executable) {
        super(executable);
        this.executable = executable;
    }

    @Override
    public String name() {
        return this.executable instanceof Constructor ? "<init>" : this.executable.getName();
    }

    @Override
    public ClassData declaringClass() {
        return ReflectionClassData.of(this.executable.getDeclaringClass());
    }

    @Override
    public int parameterCount() {
        return this.executable.getParameterCount();
    }

    @Override
    public int modifiers() {
        return this.executable.getModifiers();
    }

    @Override
    public TypeData returnType() {
        if (this.returnType == null) {
            if (this.executable instanceof Method) {
                Class<?> type;
                Method method = (Method)this.executable;
                try {
                    type = method.getGenericReturnType();
                }
                catch (TypeNotPresentException | GenericSignatureFormatError | MalformedParameterizedTypeException e) {
                    LOGGER.warn("Can not get generic return type of method {}", (Object)this.executable);
                    type = method.getReturnType();
                }
                this.returnType = ReflectionClassDataFetcher.type(type, method.getReturnType());
            } else {
                this.returnType = this.declaringClass();
            }
        }
        return this.returnType;
    }

    @Override
    public List<TypeData> parameters() {
        if (this.parameters == null) {
            Type[] genericParameterTypes;
            Class<?>[] parameterTypes = this.executable.getParameterTypes();
            try {
                genericParameterTypes = this.executable.getGenericParameterTypes();
            }
            catch (TypeNotPresentException | GenericSignatureFormatError | MalformedParameterizedTypeException e) {
                LOGGER.warn("Can not get generic parameter types of method {}", (Object)this.executable);
                genericParameterTypes = parameterTypes;
            }
            this.parameters = new ArrayList<TypeData>(parameterTypes.length);
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                this.parameters.add(ReflectionClassDataFetcher.type(genericParameterTypes[i], parameterTypes[i]));
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isVarArgs() {
        return this.executable.isVarArgs();
    }
}

