/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.reflect;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.FieldData;
import youyihj.zenutils.impl.member.LookupRequester;
import youyihj.zenutils.impl.member.reflect.ReflectionAnnotatedMember;
import youyihj.zenutils.impl.member.reflect.ReflectionExecutableData;
import youyihj.zenutils.impl.member.reflect.ReflectionFieldData;

public class ReflectionClassData
extends ReflectionAnnotatedMember
implements ClassData {
    private final Class<?> clazz;
    private final Map<LookupRequester, List<FieldData>> fieldsCache = new EnumMap<LookupRequester, List<FieldData>>(LookupRequester.class);
    private final Map<LookupRequester, List<ExecutableData>> methodsCache = new EnumMap<LookupRequester, List<ExecutableData>>(LookupRequester.class);
    private final Map<LookupRequester, List<ExecutableData>> constructorsCache = new EnumMap<LookupRequester, List<ExecutableData>>(LookupRequester.class);
    private static final Map<Class<?>, ReflectionClassData> POOL = new HashMap();

    private ReflectionClassData(Class<?> clazz) {
        super(clazz);
        this.clazz = clazz;
    }

    public static ReflectionClassData of(Class<?> clazz) {
        return POOL.computeIfAbsent(clazz, ReflectionClassData::new);
    }

    @Override
    public String name() {
        return this.clazz.getCanonicalName();
    }

    @Override
    public String internalName() {
        return org.objectweb.asm.Type.getInternalName(this.clazz);
    }

    @Override
    public List<FieldData> fields(LookupRequester requester) {
        return this.fieldsCache.computeIfAbsent(requester, this::fields0);
    }

    private List<FieldData> fields0(LookupRequester requester) {
        ArrayList fields = Lists.newArrayList((Object[])this.clazz.getDeclaredFields());
        for (Class<?> superclass = this.clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            fields.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        return fields.stream().filter(it -> requester.allows(it.getModifiers())).map(ReflectionFieldData::new).collect(Collectors.toList());
    }

    @Override
    public List<ExecutableData> methods(LookupRequester requester) {
        return this.methodsCache.computeIfAbsent(requester, this::methods0);
    }

    private List<ExecutableData> methods0(LookupRequester requester) {
        ArrayList<ExecutableData> methods = new ArrayList<ExecutableData>();
        HashSet<String> usedDescriptors = new HashSet<String>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!requester.allows(method.getModifiers())) continue;
            ReflectionExecutableData methodData = new ReflectionExecutableData(method);
            methods.add(methodData);
            usedDescriptors.add(methodData.name() + methodData.descriptor());
        }
        ClassData superClass = this.superClass();
        if (superClass != null) {
            for (ExecutableData superMethod : superClass.methods(requester)) {
                if (!usedDescriptors.add(superMethod.name() + superMethod.descriptor())) continue;
                methods.add(superMethod);
            }
        }
        for (Class<?> itf : this.clazz.getInterfaces()) {
            for (Method method : itf.getDeclaredMethods()) {
                ReflectionExecutableData interfaceMethodData;
                if (!requester.allows(method.getModifiers()) || !usedDescriptors.add((interfaceMethodData = new ReflectionExecutableData(method)).name() + interfaceMethodData.descriptor())) continue;
                methods.add(interfaceMethodData);
            }
        }
        return methods;
    }

    @Override
    public List<ExecutableData> constructors(LookupRequester requester) {
        return this.constructorsCache.computeIfAbsent(requester, this::constructors0);
    }

    private List<ExecutableData> constructors0(LookupRequester requester) {
        return Arrays.stream(this.clazz.getDeclaredConstructors()).filter(it -> requester.allows(it.getModifiers())).map(ReflectionExecutableData::new).collect(Collectors.toList());
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isAssignableFrom(ClassData classData) {
        if (classData instanceof ReflectionClassData) {
            return this.clazz.isAssignableFrom(((ReflectionClassData)classData).clazz);
        }
        return false;
    }

    @Override
    @Nullable
    public ClassData superClass() {
        return this.clazz.getSuperclass() != null ? ReflectionClassData.of(this.clazz.getSuperclass()) : null;
    }

    @Override
    public List<ClassData> interfaces() {
        return Arrays.stream(this.clazz.getInterfaces()).map(ReflectionClassData::of).collect(Collectors.toList());
    }

    @Override
    public Type javaType() {
        return this.clazz;
    }

    @Override
    public String descriptor() {
        return org.objectweb.asm.Type.getDescriptor(this.clazz);
    }

    @Override
    public ClassData asClassData() {
        return this;
    }

    public String toString() {
        return this.descriptor();
    }
}

